/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.ConsoleDialogs;
import com.eviware.soapui.support.HelpActionMarker;
import com.eviware.soapui.support.UIUtils;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.components.ConfigurationDialog;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SwingConfigurationDialogImpl;
import com.eviware.soapui.support.swing.GradientPanel;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.swing.SwingUtils;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.x.dialogs.XDialogs;
import com.eviware.x.dialogs.XFileDialogs;
import com.eviware.x.impl.swing.SwingDialogs;
import com.eviware.x.impl.swing.SwingFileDialogs;
import com.jgoodies.looks.HeaderStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISupport {
    private static Component frame;
    private static Map<String, ImageIcon> iconCache;
    public static Dimension TOOLBAR_BUTTON_DIMENSION;
    private static Boolean isWindows;
    private static XDialogs dialogs;
    private static XFileDialogs fileDialogs;
    private static UIUtils uiUtils;
    private static ToolHost toolHost;
    private static Cursor hourglassCursor;
    private static Cursor defaultCursor;
    public static ImageIcon TOOL_ICON;
    public static ImageIcon OPTIONS_ICON;
    public static ImageIcon HELP_ICON;

    public static void setMainFrame(Component frame) {
        UISupport.frame = frame;
        UISupport.setDialogs(new SwingDialogs(frame));
        UISupport.setFileDialogs(new SwingFileDialogs(frame));
    }

    public static void setDialogs(XDialogs xDialogs) {
        dialogs = xDialogs;
    }

    public static void setFileDialogs(XFileDialogs xFileDialogs) {
        fileDialogs = xFileDialogs;
    }

    public static ToolHost getToolHost() {
        return toolHost;
    }

    public static void setToolHost(ToolHost host) {
        toolHost = host;
    }

    public static Frame getMainFrame() {
        return (Frame)(frame instanceof Frame ? frame : null);
    }

    public static XDialogs getDialogs() {
        return dialogs;
    }

    public static XFileDialogs getFileDialogs() {
        return fileDialogs;
    }

    public static ConfigurationDialog createConfigurationDialog(String name, String helpUrl, String description, ImageIcon icon) {
        return new SwingConfigurationDialogImpl(name, helpUrl, description, icon);
    }

    public static ConfigurationDialog createConfigurationDialog(String name, String helpUrl) {
        return new SwingConfigurationDialogImpl(name, helpUrl, null, null);
    }

    public static ConfigurationDialog createConfigurationDialog(String name) {
        return new SwingConfigurationDialogImpl(name, null, null, null);
    }

    public static void showErrorMessage(String message) {
        dialogs.showErrorMessage(message);
    }

    public static boolean confirm(String question, String title) {
        return dialogs.confirm(question, title);
    }

    public static String prompt(String question, String title, String value) {
        return dialogs.prompt(question, title, value);
    }

    public static String prompt(String question, String title) {
        return dialogs.prompt(question, title);
    }

    public static boolean stopCellEditing(JTable table) {
        try {
            int column = table.getEditingColumn();
            if (column > -1) {
                TableCellEditor cellEditor = table.getColumnModel().getColumn(column).getCellEditor();
                if (cellEditor == null) {
                    cellEditor = table.getDefaultEditor(table.getColumnClass(column));
                }
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static JPanel createProgressBarPanel(JProgressBar progressBar, int space, boolean indeterimate) {
        JPanel panel = new JPanel(new BorderLayout());
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setString("");
        progressBar.setIndeterminate(indeterimate);
        progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
        panel.setBorder(BorderFactory.createEmptyBorder(space, space, space, space));
        panel.add((Component)progressBar, "Center");
        return panel;
    }

    public static JSplitPane createHorizontalSplit() {
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setUI(new SoapUISplitPaneUI());
        splitPane.setDividerSize(10);
        splitPane.setOneTouchExpandable(true);
        return splitPane;
    }

    public static JSplitPane createHorizontalSplit(Component leftComponent, Component rightComponent) {
        JSplitPane splitPane = UISupport.createHorizontalSplit();
        splitPane.setLeftComponent(leftComponent);
        splitPane.setRightComponent(rightComponent);
        return splitPane;
    }

    public static JSplitPane createVerticalSplit() {
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setUI(new SoapUISplitPaneUI());
        splitPane.setDividerSize(10);
        splitPane.setOneTouchExpandable(true);
        splitPane.setBorder(null);
        return splitPane;
    }

    public static JSplitPane createVerticalSplit(Component topComponent, Component bottomComponent) {
        JSplitPane splitPane = UISupport.createVerticalSplit();
        splitPane.setLeftComponent(topComponent);
        splitPane.setRightComponent(bottomComponent);
        return splitPane;
    }

    public static void centerDialog(JDialog dialog) {
        Rectangle b;
        Dimension sz = dialog.getSize();
        Rectangle rectangle = b = frame == null ? null : frame.getBounds();
        if (dialog.getOwner().isVisible()) {
            b = dialog.getOwner().getBounds();
        } else if (b == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            b = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        }
        dialog.setLocation((int)((b.getWidth() - sz.getWidth()) / 2.0), (int)((b.getHeight() - sz.getHeight()) / 2.0));
    }

    public static void showDialog(JDialog dialog) {
        UISupport.centerDialog(dialog);
        dialog.setVisible(true);
    }

    public static ImageIcon createImageIcon(String path) {
        if (iconCache.containsKey(path)) {
            return iconCache.get(path);
        }
        URL imgURL = SoapUI.class.getResource(path);
        if (imgURL != null) {
            try {
                ImageIcon imageIcon = new ImageIcon(imgURL);
                iconCache.put(path, imageIcon);
                return imageIcon;
            }
            catch (Throwable e) {
                System.err.println("Failed to create icon: " + e);
                return null;
            }
        }
        System.err.println("Couldn't find icon file: " + path);
        return null;
    }

    public static void showInfoMessage(String message) {
        dialogs.showInfoMessage(message);
    }

    public static void showInfoMessage(String message, String title) {
        dialogs.showInfoMessage(message, title);
    }

    public static <T> T prompt(String question, String title, T[] objects) {
        return (T)dialogs.prompt(question, title, objects);
    }

    public static <T> T prompt(String question, String title, T[] objects, String value) {
        return (T)dialogs.prompt(question, title, objects, value);
    }

    public static JButton createToolbarButton(Action action) {
        JButton result = new JButton(action);
        result.setPreferredSize(TOOLBAR_BUTTON_DIMENSION);
        result.setText("");
        return result;
    }

    public static JButton createToolbarButton(Action action, boolean enabled) {
        JButton result = UISupport.createToolbarButton(action);
        result.setEnabled(enabled);
        return result;
    }

    public static JPanel createTabPanel(JTabbedPane tabs, boolean addBorder) {
        GradientPanel panel = new GradientPanel(new BorderLayout());
        Color color = UIManager.getDefaults().getColor("Panel.background");
        Color darker = color.darker();
        panel.setForeground(new Color((color.getRed() + darker.getRed()) / 2, (color.getGreen() + darker.getGreen()) / 2, (color.getBlue() + darker.getBlue()) / 2));
        if (tabs.getTabPlacement() == 2 || tabs.getTabPlacement() == 4) {
            panel.setDirection(1);
        }
        panel.add((Component)tabs, "Center");
        if (addBorder) {
            if (tabs.getTabPlacement() == 1) {
                panel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY));
            } else {
                panel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.GRAY));
            }
        }
        tabs.setBorder(null);
        return panel;
    }

    public static void showPopup(JPopupMenu popup, JComponent invoker, Point p) {
        popup.setInvoker(invoker);
        popup.setLocation((int)(invoker.getLocationOnScreen().getX() + p.getX()), (int)(invoker.getLocationOnScreen().getY() + p.getY()));
        popup.setVisible(true);
    }

    public static DesktopPanel selectAndShow(ModelItem modelItem) {
        SoapUI.selectModelItem(modelItem);
        return UISupport.showDesktopPanel(modelItem);
    }

    public static DesktopPanel showDesktopPanel(ModelItem modelItem) {
        SoapUIDesktop desktop = SoapUI.getDesktop();
        return desktop == null ? null : desktop.showDesktopPanel(modelItem);
    }

    public static DesktopPanel showDesktopPanel(DesktopPanel desktopPanel) {
        SoapUIDesktop desktop = SoapUI.getDesktop();
        return desktop == null ? null : desktop.showDesktopPanel(desktopPanel);
    }

    public static Boolean confirmOrCancel(String question, String title) {
        return dialogs.confirmOrCancel(question, title);
    }

    public static JPanel buildPanelWithToolbar(JComponent top, JComponent content) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)top, "North");
        p.add((Component)content, "Center");
        return p;
    }

    public static JPanel buildPanelWithToolbarAndStatusBar(JComponent top, JComponent content, JComponent bottom) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)top, "North");
        p.add((Component)content, "Center");
        p.add((Component)bottom, "South");
        return p;
    }

    public static Dimension getPreferredButtonSize() {
        return TOOLBAR_BUTTON_DIMENSION;
    }

    public static void showErrorMessage(Exception ex) {
        UISupport.showErrorMessage(ex.toString());
    }

    public static Component wrapInEmptyPanel(JComponent component, Border border) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "Center");
        panel.setBorder(border);
        return panel;
    }

    public static boolean isWindows() {
        if (isWindows == null) {
            isWindows = new Boolean(System.getProperty("os.name").indexOf("Windows") >= 0);
        }
        return isWindows;
    }

    public static void setHourglassCursor() {
        if (frame == null) {
            return;
        }
        if (hourglassCursor == null) {
            hourglassCursor = new Cursor(3);
        }
        frame.setCursor(hourglassCursor);
    }

    public static void resetCursor() {
        if (frame == null) {
            return;
        }
        if (defaultCursor == null) {
            defaultCursor = new Cursor(0);
        }
        frame.setCursor(defaultCursor);
    }

    public static void setUIUtils(UIUtils utils) {
        uiUtils = utils;
    }

    public static void invokeLater(Runnable runnable) {
        uiUtils.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws Exception {
        uiUtils.invokeAndWait(runnable);
    }

    public static JXToolBar createToolbar() {
        JXToolBar toolbar = new JXToolBar();
        toolbar.setRollover(true);
        toolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        toolbar.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        return toolbar;
    }

    public static KeyStroke getKeyStroke(String keyStroke) {
        try {
            keyStroke = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? keyStroke.replaceAll("menu", "meta") : keyStroke.replaceAll("menu", "ctrl");
        }
        catch (HeadlessException e) {
            keyStroke = keyStroke.replaceAll("menu", "ctrl");
        }
        return KeyStroke.getKeyStroke(keyStroke);
    }

    public static Component buildDescription(String title, String string, ImageIcon icon) {
        GradientPanel panel = new GradientPanel(new BorderLayout());
        panel.setBackground(UIManager.getColor("control"));
        panel.setForeground(Color.WHITE);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JLabel label = new JLabel("<html><div style=\"font-size: 9px\">" + string + "</div></html>");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)label, "Center");
        innerPanel.setOpaque(false);
        JLabel titleLabel = new JLabel("<html><div style=\"font-size: 9px\"><b>" + title + "</b></div></html>");
        innerPanel.add((Component)titleLabel, "North");
        panel.add((Component)innerPanel, "Center");
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            panel.add((Component)iconLabel, "East");
        }
        return panel;
    }

    public static void setPreferredHeight(Component component, int heigth) {
        component.setPreferredSize(new Dimension((int)component.getPreferredSize().getWidth(), heigth));
    }

    public static JButtonBar initDialogActions(ActionList actions, final JDialog dialog) {
        JButtonBar buttons = new JButtonBar();
        buttons.addActions(actions);
        dialog.getRootPane().setDefaultButton(buttons.getDefaultButton());
        dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        for (int c = 0; c < actions.getActionCount(); ++c) {
            Action action = actions.getActionAt(c);
            if (!(action instanceof HelpActionMarker)) continue;
            dialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "HELP");
            dialog.getRootPane().getActionMap().put("HELP", action);
            break;
        }
        return buttons;
    }

    public static <T extends JComponent> T addTitledBorder(T component, String title) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), title), component.getBorder())));
        return component;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static <T> T prompt(String question, String title, List<T> objects) {
        return (T)dialogs.prompt(question, title, objects.toArray());
    }

    public static <T> T prompt(String question, String title, List<T> objects, String value) {
        return (T)dialogs.prompt(question, title, objects.toArray(), value);
    }

    public static void showExtendedInfo(String title, String description, String content, Dimension size) {
        dialogs.showExtendedInfo(title, description, content, size);
    }

    public static boolean confirmExtendedInfo(String title, String description, String content, Dimension size) {
        return dialogs.confirmExtendedInfo(title, description, content, size);
    }

    public static Boolean confirmOrCancelExtendedInfo(String title, String description, String content, Dimension size) {
        return dialogs.confirmOrCancleExtendedInfo(title, description, content, size);
    }

    static {
        iconCache = new HashMap<String, ImageIcon>();
        TOOLBAR_BUTTON_DIMENSION = new Dimension(22, 21);
        UISupport.setDialogs(new ConsoleDialogs());
        uiUtils = new SwingUtils();
        TOOL_ICON = UISupport.createImageIcon("/applications-system.png");
        OPTIONS_ICON = UISupport.createImageIcon("/preferences-system.png");
        HELP_ICON = UISupport.createImageIcon("/help-browser.png");
    }
}

