/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.support.log.JLogList;
import java.awt.Component;
import javax.swing.JTabbedPane;
import org.apache.log4j.spi.LoggingEvent;

public class Log4JMonitor
extends JTabbedPane {
    private JLogList defaultLogArea;

    public Log4JMonitor() {
        super(3, 1);
    }

    public JLogList addLogArea(String title, String loggerName, boolean isDefault) {
        JLogList logArea = new JLogList(title);
        logArea.addLogger(loggerName, !isDefault);
        this.addTab(title, logArea);
        if (isDefault) {
            this.defaultLogArea = logArea;
        }
        return logArea;
    }

    public void logEvent(Object msg) {
        if (msg instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)msg;
            String loggerName = event.getLoggerName();
            for (int c = 0; c < this.getTabCount(); ++c) {
                JLogList logArea;
                Component tabComponent = this.getComponentAt(c);
                if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
                logArea.addLine(msg);
            }
        } else if (this.defaultLogArea != null) {
            this.defaultLogArea.addLine(msg);
        }
    }

    public boolean hasLogArea(String loggerName) {
        for (int c = 0; c < this.getTabCount(); ++c) {
            JLogList logArea;
            Component tabComponent = this.getComponentAt(c);
            if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
            return true;
        }
        return false;
    }
}

