/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SoapUISplitPaneUI
extends BasicSplitPaneUI {
    private boolean hasBeenDragged;
    private static final ImageIcon upArrow = UISupport.createImageIcon("/up_arrow.gif");
    private static final ImageIcon leftArrow = UISupport.createImageIcon("/left_arrow.gif");
    private static final ImageIcon rightArrow = UISupport.createImageIcon("/right_arrow.gif");
    private static final ImageIcon downArrow = UISupport.createImageIcon("/down_arrow.gif");

    protected void finishDraggingTo(int location) {
        super.finishDraggingTo(location);
        this.hasBeenDragged = true;
    }

    public void resetToPreferredSizes(JSplitPane jc) {
        super.resetToPreferredSizes(jc);
        this.hasBeenDragged = false;
    }

    public boolean hasBeenDragged() {
        return this.hasBeenDragged;
    }

    public void setHasBeenDragged(boolean hasBeenDragged) {
        this.hasBeenDragged = hasBeenDragged;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        return new SoapUIDivider(this);
    }

    public void setDividerLocation(JSplitPane jc, int location) {
        super.setDividerLocation(jc, location);
        this.enableOneTouchButtons(jc, location);
    }

    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        this.enableOneTouchButtons(this.getSplitPane(), this.getSplitPane().getDividerLocation());
    }

    private void enableOneTouchButtons(JSplitPane jc, int location) {
        JButton leftButton = ((SoapUIDivider)this.getDivider()).getLeftButton();
        JButton rightButton = ((SoapUIDivider)this.getDivider()).getRightButton();
        if (leftButton != null) {
            leftButton.setEnabled(location > jc.getMinimumDividerLocation() && jc.getRightComponent() != null && jc.getRightComponent().isVisible());
        }
        if (rightButton != null) {
            rightButton.setEnabled(location < jc.getMaximumDividerLocation() && jc.getLeftComponent() != null && jc.getLeftComponent().isVisible());
        }
    }

    public class SoapUIDivider
    extends BasicSplitPaneDivider {
        public SoapUIDivider(BasicSplitPaneUI ui) {
            super(ui);
            this.setLayout(new SoapUIDividerLayout());
        }

        protected JButton createLeftOneTouchButton() {
            if (SoapUISplitPaneUI.this.getSplitPane().getOrientation() == 0) {
                JButton b = new JButton(upArrow);
                b.setMinimumSize(new Dimension(8, 6));
                b.setFocusPainted(false);
                b.setBorderPainted(false);
                b.setRequestFocusEnabled(false);
                b.setBorder(null);
                b.setCursor(Cursor.getPredefinedCursor(0));
                return b;
            }
            JButton b = new JButton(leftArrow);
            b.setMinimumSize(new Dimension(6, 8));
            b.setFocusPainted(false);
            b.setBorderPainted(false);
            b.setRequestFocusEnabled(false);
            b.setBorder(null);
            b.setCursor(Cursor.getPredefinedCursor(0));
            return b;
        }

        protected JButton createRightOneTouchButton() {
            if (SoapUISplitPaneUI.this.getSplitPane().getOrientation() == 0) {
                JButton b = new JButton(downArrow);
                b.setMinimumSize(new Dimension(8, 6));
                b.setFocusPainted(false);
                b.setBorderPainted(false);
                b.setRequestFocusEnabled(false);
                b.setBorder(null);
                b.setCursor(Cursor.getPredefinedCursor(0));
                return b;
            }
            JButton b = new JButton(rightArrow);
            b.setMinimumSize(new Dimension(6, 8));
            b.setFocusPainted(false);
            b.setBorderPainted(false);
            b.setRequestFocusEnabled(false);
            b.setBorder(null);
            b.setCursor(Cursor.getPredefinedCursor(0));
            return b;
        }

        public JButton getLeftButton() {
            return this.leftButton;
        }

        public JButton getRightButton() {
            return this.rightButton;
        }

        protected class SoapUIDividerLayout
        implements LayoutManager {
            private int lastOrientation;

            public SoapUIDividerLayout() {
                this.lastOrientation = SoapUISplitPaneUI.this.getOrientation();
            }

            public void layoutContainer(Container c) {
                if (this.lastOrientation != SoapUISplitPaneUI.this.getOrientation()) {
                    if (SoapUIDivider.this.leftButton != null) {
                        SoapUIDivider.this.leftButton.setIcon(SoapUISplitPaneUI.this.getOrientation() == 0 ? upArrow : leftArrow);
                        SoapUIDivider.this.leftButton.setMinimumSize(SoapUISplitPaneUI.this.getOrientation() == 0 ? new Dimension(8, 6) : new Dimension(6, 8));
                    }
                    if (SoapUIDivider.this.rightButton != null) {
                        SoapUIDivider.this.rightButton.setIcon(SoapUISplitPaneUI.this.getOrientation() == 0 ? downArrow : rightArrow);
                        SoapUIDivider.this.rightButton.setMinimumSize(SoapUISplitPaneUI.this.getOrientation() == 0 ? new Dimension(8, 6) : new Dimension(6, 8));
                    }
                    this.lastOrientation = SoapUISplitPaneUI.this.getOrientation();
                }
                if (SoapUISplitPaneUI.this.getOrientation() == 0) {
                    if (SoapUIDivider.this.leftButton != null) {
                        SoapUIDivider.this.leftButton.setBounds(2, 2, 8, 6);
                    }
                    if (SoapUIDivider.this.rightButton != null) {
                        SoapUIDivider.this.rightButton.setBounds(12, 2, 8, 6);
                    }
                } else {
                    if (SoapUIDivider.this.leftButton != null) {
                        SoapUIDivider.this.leftButton.setBounds(2, 2, 6, 8);
                    }
                    if (SoapUIDivider.this.rightButton != null) {
                        SoapUIDivider.this.rightButton.setBounds(2, 12, 6, 8);
                    }
                }
            }

            public Dimension preferredLayoutSize(Container c) {
                return this.minimumLayoutSize(c);
            }

            public void removeLayoutComponent(Component c) {
            }

            public void addLayoutComponent(String string, Component c) {
            }

            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }
        }
    }
}

