/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportLoadTestLogAction;
import com.eviware.soapui.impl.wsdl.loadtest.data.actions.ExportStatisticsAction;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLog;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.tools.SoapUITestCaseRunner;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SoapUILoadTestRunner
implements LoadTestRunListener {
    private String projectFile;
    private String testSuite;
    private String testCase;
    private String endpoint;
    private static final Logger log = Logger.getLogger(SoapUILoadTestRunner.class);
    private String domain;
    private String password;
    private String username;
    private String host;
    private String loadTest;
    private boolean printReport;
    private String outputFolder;
    private List<LoadTestRunner> failedTests = new ArrayList<LoadTestRunner>();
    private int testCaseCount;
    private int loadTestCount;
    private String wssPasswordType;
    public static String TITLE = "soapUI 1.7.1 LoadTest Runner";

    public static void main(String[] args) throws Exception {
        System.out.println(TITLE);
        SoapUI.initSoapUILog();
        SoapUILoadTestRunner runner = new SoapUILoadTestRunner();
        Options options = new Options();
        options.addOption("e", true, "Sets the endpoint");
        options.addOption("s", true, "Sets the testsuite");
        options.addOption("c", true, "Sets the testcase");
        options.addOption("l", true, "Sets the loadtest");
        options.addOption("u", true, "Sets the username");
        options.addOption("p", true, "Sets the password");
        options.addOption("w", true, "Sets the WSS password type, either 'Text' or 'Digest'");
        options.addOption("d", true, "Sets the domain");
        options.addOption("h", true, "Sets the host");
        options.addOption("r", false, "Exports statistics and testlogs for each loadtest run");
        options.addOption("f", true, "Sets the output folder to export to");
        options.addOption("t", true, "Sets the soapui-settings.xml file to use");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String[] args2 = cmd.getArgs();
        if (args2.length != 1) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("loadtestrunner [options] <soapui-project-file>", options);
            System.err.println("Missing soapUI project file..");
            return;
        }
        runner.setProjectFile(args2[0]);
        if (cmd.hasOption("e")) {
            runner.setEndpoint(cmd.getOptionValue("e"));
        }
        if (cmd.hasOption("s")) {
            runner.setTestSuite(cmd.getOptionValue("s"));
        }
        if (cmd.hasOption("c")) {
            runner.setTestCase(cmd.getOptionValue("c"));
        }
        if (cmd.hasOption("l")) {
            runner.setLoadTest(cmd.getOptionValue("l"));
        }
        if (cmd.hasOption("u")) {
            runner.setUsername(cmd.getOptionValue("u"));
        }
        if (cmd.hasOption("p")) {
            runner.setPassword(cmd.getOptionValue("p"));
        }
        if (cmd.hasOption("w")) {
            runner.setWssPasswordType(cmd.getOptionValue("w"));
        }
        if (cmd.hasOption("d")) {
            runner.setDomain(cmd.getOptionValue("d"));
        }
        if (cmd.hasOption("h")) {
            runner.setHost(cmd.getOptionValue("h"));
        }
        if (cmd.hasOption("f")) {
            runner.setOutputFolder(cmd.getOptionValue("f"));
        }
        if (cmd.hasOption("t")) {
            SoapUI.initSettings(cmd.getOptionValue("t"));
        }
        runner.setPrintReport(cmd.hasOption("r"));
        try {
            SoapUI.loadExtLibs();
            if (SoapUI.getSettings().getBoolean(UISettings.DONT_DISABLE_GROOVY_LOG)) {
                SoapUILoadTestRunner.initGroovyLog();
            }
            runner.run();
            System.exit(0);
        }
        catch (SoapUIException e) {
            log.error((Object)e.toString());
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void initGroovyLog() {
        Logger logger = Logger.getLogger((String)"groovy.log");
        ConsoleAppender appender = new ConsoleAppender();
        appender.setWriter((Writer)new OutputStreamWriter(System.out));
        appender.setLayout((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n"));
        logger.addAppender((Appender)appender);
    }

    public SoapUILoadTestRunner() {
        SoapUI.setTestMonitor(new TestMonitor());
    }

    public void setLoadTest(String loadTest) {
        this.loadTest = loadTest;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setPrintReport(boolean printReport) {
        this.printReport = printReport;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDomain(String domain) {
        log.info((Object)("Setting domain to [" + domain + "]"));
        this.domain = domain;
    }

    public void setPassword(String password) {
        log.info((Object)("Setting password to [" + password + "]"));
        this.password = password;
    }

    public void setWssPasswordType(String wssPasswordType) {
        this.wssPasswordType = wssPasswordType;
    }

    public void setUsername(String username) {
        log.info((Object)("Setting username to [" + username + "]"));
        this.username = username;
    }

    public void run() throws Exception {
        if (!new File(this.projectFile).exists()) {
            throw new SoapUIException("soapUI project file [" + this.projectFile + "] not found");
        }
        WsdlProject project = new WsdlProject(this.projectFile, null);
        int suiteCount = 0;
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            if (this.testSuite != null && !project.getTestSuiteAt(c).getName().equalsIgnoreCase(this.testSuite)) continue;
            this.runSuite(project.getTestSuiteAt(c));
            ++suiteCount;
        }
        if (suiteCount == 0) {
            log.warn((Object)("No test-suites matched argument [" + this.testSuite + "]"));
        } else if (this.testCaseCount == 0) {
            log.warn((Object)("No test-cases matched argument [" + this.testCase + "]"));
        } else if (this.loadTestCount == 0) {
            log.warn((Object)("No load-tests matched argument [" + this.loadTest + "]"));
        } else if (!this.failedTests.isEmpty()) {
            log.info((Object)(this.failedTests.size() + " load tests failed:"));
            for (LoadTestRunner loadTestRunner : this.failedTests) {
                log.info((Object)(loadTestRunner.getLoadTest().getName() + ": " + loadTestRunner.getReason()));
            }
            throw new SoapUIException("LoadTests failed");
        }
    }

    public void runSuite(TestSuite suite) {
        long start = System.currentTimeMillis();
        for (int c = 0; c < suite.getTestCaseCount(); ++c) {
            String name = suite.getTestCaseAt(c).getName();
            if (this.testCase == null || name.equalsIgnoreCase(this.testCase)) {
                this.runTestCase(suite.getTestCaseAt(c));
                ++this.testCaseCount;
                continue;
            }
            log.info((Object)("Skipping testcase [" + name + "], filter is [" + this.testCase + "]"));
        }
        log.info((Object)("soapUI suite [" + suite.getName() + "] finished in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private void runTestCase(TestCase testCase) {
        for (int c = 0; c < testCase.getLoadTestCount(); ++c) {
            String name = testCase.getLoadTestAt(c).getName();
            if (this.loadTest != null && !this.loadTest.equalsIgnoreCase(name)) continue;
            this.runWsdlLoadTest((WsdlLoadTest)testCase.getLoadTestAt(c));
            ++this.loadTestCount;
        }
    }

    private void runWsdlLoadTest(WsdlLoadTest loadTest) {
        try {
            log.info((Object)("Running LoadTest [" + loadTest.getName() + "]"));
            loadTest.addLoadTestRunListener(this);
            LoadTestRunner runner = loadTest.run();
            while (runner.getStatus() == LoadTestRunner.Status.RUNNING) {
                log.info((Object)("LoadTest [" + loadTest.getName() + "] progress: " + runner.getProgress() + ", " + runner.getRunningThreadCount()));
                Thread.sleep(1000L);
            }
            log.info((Object)("LoadTest [" + loadTest.getName() + "] finished with status " + runner.getStatus().toString()));
            if (this.printReport) {
                log.info((Object)("Exporting log and statistics for LoadTest [" + loadTest.getName() + "]"));
                loadTest.getStatisticsModel().finish();
                this.exportLog(loadTest);
                this.exportStatistics(loadTest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    private void exportStatistics(WsdlLoadTest loadTest) throws IOException {
        ExportStatisticsAction exportStatisticsAction = new ExportStatisticsAction(loadTest.getStatisticsModel());
        String statisticsFileName = loadTest.getName() + "-statistics.txt";
        if (this.outputFolder != null) {
            this.ensureOutputFolder();
            statisticsFileName = this.outputFolder + File.separator + statisticsFileName;
        }
        int cnt = exportStatisticsAction.exportToFile(new File(statisticsFileName));
        log.info((Object)("Exported " + cnt + " statistics to [" + statisticsFileName + "]"));
    }

    private void exportLog(WsdlLoadTest loadTest) throws IOException {
        LoadTestLog loadTestLog = loadTest.getLoadTestLog();
        ExportLoadTestLogAction exportLoadTestLogAction = new ExportLoadTestLogAction(loadTestLog);
        String logFileName = loadTest.getName() + "-log.txt";
        if (this.outputFolder != null) {
            this.ensureOutputFolder();
            logFileName = this.outputFolder + File.separator + logFileName;
        }
        int cnt = exportLoadTestLogAction.exportToFile(new File(logFileName));
        log.info((Object)("Exported " + cnt + " log items to [" + logFileName + "]"));
        int errorCnt = 0;
        for (int c = 0; c < loadTestLog.getSize(); ++c) {
            LoadTestLogEntry entry = (LoadTestLogEntry)loadTestLog.getElementAt(c);
            if (entry == null || !entry.isError()) continue;
            String entryFileName = loadTest.getName() + "-error-" + errorCnt++ + "-entry.txt";
            if (this.outputFolder != null) {
                this.ensureOutputFolder();
                entryFileName = this.outputFolder + File.separator + entryFileName;
            }
            try {
                entry.exportToFile(entryFileName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info((Object)("Exported " + errorCnt + " error results"));
    }

    private void ensureOutputFolder() {
        File folder = new File(this.outputFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public void setProjectFile(String projectFile) {
        log.info((Object)("setting projectFile to [" + projectFile + "]"));
        this.projectFile = projectFile;
    }

    public void setTestCase(String testCase) {
        log.info((Object)("setting testCase to [" + testCase + "]"));
        this.testCase = testCase;
    }

    public void setEndpoint(String endpoint) {
        log.info((Object)("setting test endpoint to [" + endpoint + "]"));
        this.endpoint = endpoint.trim();
    }

    public void setTestSuite(String testSuite) {
        log.info((Object)("setting testSuite to [" + testSuite + "]"));
        this.testSuite = testSuite;
    }

    public void afterLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
        if (loadTestRunner.getStatus() == LoadTestRunner.Status.FAILED) {
            this.failedTests.add(loadTestRunner);
        }
    }

    public void afterTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
    }

    public void afterTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext, TestStepResult testStepResult) {
    }

    public void beforeLoadTest(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }

    public void beforeTestCase(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext) {
    }

    public void beforeTestStep(LoadTestRunner loadTestRunner, LoadTestRunContext context, TestRunner testRunner, TestRunContext runContext, TestStep testStep) {
        if (testStep instanceof WsdlTestRequestStep) {
            WsdlTestRequestStep requestStep = (WsdlTestRequestStep)testStep;
            if (this.endpoint != null && this.endpoint.length() > 0) {
                requestStep.getTestRequest().setEndpoint(this.endpoint);
            }
            if (this.host != null && this.host.length() > 0) {
                try {
                    String ep = SoapUITestCaseRunner.replaceHost(requestStep.getTestRequest().getEndpoint(), this.host);
                    requestStep.getTestRequest().setEndpoint(ep);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to set host on endpoint", (Throwable)e);
                }
            }
            if (this.username != null && this.username.length() > 0) {
                requestStep.getTestRequest().setUsername(this.username);
            }
            if (this.password != null && this.password.length() > 0) {
                requestStep.getTestRequest().setPassword(this.password);
            }
            if (this.domain != null && this.domain.length() > 0) {
                requestStep.getTestRequest().setDomain(this.domain);
            }
            if (this.wssPasswordType != null && this.wssPasswordType.length() > 0) {
                requestStep.getTestRequest().setWssPasswordType(this.wssPasswordType.equals("Digest") ? "PasswordDigest" : "PasswordText");
            }
        }
    }

    public void loadTestStarted(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }

    public void loadTestStopped(LoadTestRunner loadTestRunner, LoadTestRunContext context) {
    }
}

