/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"LocalJumpError"}, parent="StandardError")
public class RubyLocalJumpError
extends RubyException {
    private static ObjectAllocator LOCALJUMPERROR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyLocalJumpError(runtime2, klass);
        }
    };
    private Reason reason;

    public static RubyClass createLocalJumpErrorClass(Ruby runtime2, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime2.defineClass("LocalJumpError", standardErrorClass, LOCALJUMPERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyLocalJumpError.class);
        return nameErrorClass;
    }

    private RubyLocalJumpError(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
    }

    public RubyLocalJumpError(Ruby runtime2, RubyClass exceptionClass, String message2, Reason reason2, IRubyObject exitValue) {
        super(runtime2, exceptionClass, message2);
        this.reason = reason2;
        this.fastSetInternalVariable("reason", runtime2.newSymbol(reason2.toString()));
        this.fastSetInternalVariable("exit_value", exitValue);
    }

    @JRubyMethod(name={"reason"})
    public IRubyObject reason() {
        return (IRubyObject)this.fastGetInternalVariable("reason");
    }

    public Reason getReason() {
        return this.reason;
    }

    @JRubyMethod(name={"exit_value"})
    public IRubyObject exit_value() {
        return (IRubyObject)this.fastGetInternalVariable("exit_value");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        REDO,
        BREAK,
        NEXT,
        RETURN,
        RETRY,
        NOREASON;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

