/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.annotations.Element;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.annotation.creator.AbstractCreator;
import org.jboss.metadata.annotation.creator.AnnotationContext;
import org.jboss.metadata.annotation.creator.client.ApplicationClient5MetaDataCreator;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBoss50Creator;
import org.jboss.metadata.annotation.creator.web.Web25MetaDataCreator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.client.spec.ApplicationClient5MetaData;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptAnnotationMetaDataDeployer
extends AnnotationMetaDataDeployer {
    public OptAnnotationMetaDataDeployer() {
        this.setInput(AnnotationEnvironment.class);
    }

    @Override
    protected void processMetaData(VFSDeploymentUnit unit, WebMetaData webMetaData, ApplicationClientMetaData clientMetaData, List<VirtualFile> classpath) throws Exception {
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        if (webMetaData != null) {
            this.processJBossWebMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder);
        } else if (clientMetaData != null) {
            String mainClassName = this.getMainClassName(unit);
            if (mainClassName != null) {
                this.processJBossClientMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, mainClassName);
            }
        } else {
            String mainClassName = this.getMainClassName(unit);
            if (mainClassName != null && mainClassName.length() > 0) {
                this.processJBossClientMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder, mainClassName);
            } else {
                this.processJBossMetaData(unit, (AnnotationFinder<AnnotatedElement>)finder);
            }
        }
    }

    protected void processJBossWebMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder) {
        Collection<Class<?>> classes;
        Web25MetaDataCreator creator = new Web25MetaDataCreator(finder);
        Collection<Class<?>> resourceInjectionEligibleClasses = classes = this.getClasses(unit, (AbstractCreator)creator);
        if (this.isStrictServletSpecCompliance()) {
            resourceInjectionEligibleClasses = this.getResourceInjectionEligibleWebAppClasses((DeploymentUnit)unit, classes);
        }
        if (resourceInjectionEligibleClasses.isEmpty()) {
            this.log.debug((Object)("No Java EE injection eligible classes found in web application: " + unit));
            return;
        }
        Web25MetaData annotationMetaData = creator.create(resourceInjectionEligibleClasses);
        if (annotationMetaData != null) {
            unit.addAttachment(WEB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, WebMetaData.class);
        }
    }

    protected void processJBossClientMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder, String mainClassName) throws ClassNotFoundException {
        ApplicationClient5MetaDataCreator creator = new ApplicationClient5MetaDataCreator(finder, mainClassName);
        ArrayList classes = new ArrayList(1);
        Class<?> mainClass = unit.getClassLoader().loadClass(mainClassName);
        classes.add(mainClass);
        ApplicationClient5MetaData annotationMetaData = creator.create(classes);
        if (annotationMetaData != null) {
            unit.addAttachment(CLIENT_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, ApplicationClientMetaData.class);
        }
    }

    protected void processJBossMetaData(VFSDeploymentUnit unit, AnnotationFinder<AnnotatedElement> finder) {
        Collection<Class<?>> classes;
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        JBoss50Creator creator = new JBoss50Creator(ejbJarMetaData, unit.getClassLoader(), finder);
        JBoss50MetaData annotationMetaData = creator.create(classes = this.getClasses(unit, (AbstractCreator)creator));
        if (annotationMetaData != null) {
            unit.addAttachment(EJB_ANNOTATED_ATTACHMENT_NAME, (Object)annotationMetaData, JBossMetaData.class);
        }
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, AbstractCreator creator) {
        boolean trace = this.log.isTraceEnabled();
        AnnotationEnvironment env = (AnnotationEnvironment)unit.getAttachment(AnnotationEnvironment.class);
        if (env == null) {
            if (trace) {
                this.log.trace((Object)("Cannot scan classes, missing AnnotationEnvironment as attachment: " + unit.getName()));
            }
            return Collections.emptySet();
        }
        String creatorInfo = creator.toString();
        AnnotationContext context = creator.getAnnotationContext();
        HashSet classes = new HashSet();
        Collection typeAnnotations = context.getTypeAnnotations();
        if (trace) {
            this.log.trace((Object)("Creator: " + creatorInfo + ", type annotations: " + typeAnnotations));
        }
        Iterator i$ = typeAnnotations.iterator();
        while (i$.hasNext()) {
            Class annotation;
            Class annotationClass = annotation = (Class)i$.next();
            Set elements = env.classIsAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        Collection methodAnnotations = context.getMethodAnnotations();
        if (trace) {
            this.log.trace((Object)("Creator: " + creatorInfo + ", method annotations: " + methodAnnotations));
        }
        Iterator i$2 = methodAnnotations.iterator();
        while (i$2.hasNext()) {
            Class annotation;
            Class annotationClass = annotation = (Class)i$2.next();
            Set elements = env.classHasMethodAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        Collection fieldAnnotations = context.getFieldAnnotations();
        if (trace) {
            this.log.trace((Object)("Creator: " + creatorInfo + ", field annotations: " + fieldAnnotations));
        }
        Iterator i$3 = fieldAnnotations.iterator();
        while (i$3.hasNext()) {
            Class annotation;
            Class annotationClass = annotation = (Class)i$3.next();
            Set elements = env.classHasFieldAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        if (trace) {
            this.log.trace((Object)("Annotated classes [" + unit.getName() + ", " + creatorInfo + "]: " + classes));
        }
        return classes;
    }
}

