/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.ConflictManager;

public class IvyNodeEviction {
    private IvyNode node;
    private Map selectedDeps = new HashMap();
    private Map pendingConflicts = new HashMap();
    private Map evictedDeps = new HashMap();
    private Map evictedRevs = new HashMap();
    private Map evicted = new HashMap();

    public IvyNodeEviction(IvyNode node) {
        if (node == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = node;
    }

    public Collection getResolvedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection getResolvedRevisions(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        if (resolved == null) {
            return new HashSet();
        }
        HashSet<ModuleRevisionId> resolvedRevs = new HashSet<ModuleRevisionId>();
        Iterator iter = resolved.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            resolvedRevs.add(node.getId());
            resolvedRevs.add(node.getResolvedId());
        }
        return resolvedRevs;
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection resolved) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.selectedDeps.put(moduleIdConf, new HashSet(resolved));
    }

    public Collection getEvictedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = (Collection)this.evictedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        Collection evicted = (Collection)this.evictedRevs.get(new ModuleIdConf(mid, rootModuleConf));
        if (evicted == null) {
            return new HashSet();
        }
        return new HashSet(evicted);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection evicted) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.evictedDeps.put(moduleIdConf, new HashSet(evicted));
        HashSet<ModuleRevisionId> evictedRevs = new HashSet<ModuleRevisionId>();
        Iterator iter = evicted.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            evictedRevs.add(node.getId());
            evictedRevs.add(node.getResolvedId());
        }
        this.evictedRevs.put(moduleIdConf, evictedRevs);
    }

    public boolean isEvicted(String rootModuleConf) {
        this.cleanEvicted();
        IvyNode root = this.node.getRoot();
        ModuleId moduleId = this.node.getId().getModuleId();
        Collection resolvedRevisions = root.getResolvedRevisions(moduleId, rootModuleConf);
        EvictionData evictedData = this.getEvictedData(rootModuleConf);
        return root != this.node && evictedData != null && (!resolvedRevisions.contains(this.node.getResolvedId()) || evictedData.isTransitivelyEvicted());
    }

    public boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        String[] rootModuleConfigurations = this.node.getRootModuleConfigurations();
        for (int i = 0; i < rootModuleConfigurations.length; ++i) {
            if (this.isEvicted(rootModuleConfigurations[i])) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator iter = this.evicted.keySet().iterator();
        while (iter.hasNext()) {
            String rootModuleConf = (String)iter.next();
            EvictionData ed = (EvictionData)this.evicted.get(rootModuleConf);
            Collection sel = ed.getSelected();
            if (sel == null) continue;
            Iterator iterator = sel.iterator();
            while (iterator.hasNext()) {
                IvyNode n = (IvyNode)iterator.next();
                if (!n.getRealNode().equals(this)) continue;
                iter.remove();
            }
        }
    }

    public void markEvicted(EvictionData evictionData) {
        this.evicted.put(evictionData.getRootModuleConf(), evictionData);
    }

    public EvictionData getEvictedData(String rootModuleConf) {
        this.cleanEvicted();
        return (EvictionData)this.evicted.get(rootModuleConf);
    }

    public String[] getEvictedConfs() {
        this.cleanEvicted();
        return this.evicted.keySet().toArray(new String[this.evicted.keySet().size()]);
    }

    public Collection getAllEvictingNodes() {
        HashSet allEvictingNodes = null;
        Iterator iter = this.evicted.values().iterator();
        while (iter.hasNext()) {
            EvictionData ed = (EvictionData)iter.next();
            Collection selected = ed.getSelected();
            if (selected == null) continue;
            if (allEvictingNodes == null) {
                allEvictingNodes = new HashSet();
            }
            allEvictingNodes.addAll(selected);
        }
        return allEvictingNodes;
    }

    public Collection getAllEvictingNodesDetails() {
        HashSet<String> ret = null;
        Iterator iter = this.evicted.values().iterator();
        while (iter.hasNext()) {
            EvictionData ed = (EvictionData)iter.next();
            Collection selected = ed.getSelected();
            if (selected == null) continue;
            if (ret == null) {
                ret = new HashSet<String>();
            }
            if (selected.size() == 1) {
                ret.add(selected.iterator().next() + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
                continue;
            }
            if (selected.size() <= 1) continue;
            ret.add(selected + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
        }
        return ret;
    }

    public Collection getAllEvictingConflictManagers() {
        HashSet<ConflictManager> ret = new HashSet<ConflictManager>();
        Iterator iter = this.evicted.values().iterator();
        while (iter.hasNext()) {
            EvictionData ed = (EvictionData)iter.next();
            ret.add(ed.getConflictManager());
        }
        return ret;
    }

    public EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        Collection selectedNodes = this.node.getRoot().getResolvedNodes(this.node.getModuleId(), rootModuleConf);
        Iterator iter = selectedNodes.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (!node.getResolvedId().equals(this.node.getResolvedId())) continue;
            return null;
        }
        return new EvictionData(rootModuleConf, ancestor, this.node.getRoot().getConflictManager(this.node.getModuleId()), selectedNodes);
    }

    public Collection getPendingConflicts(String rootModuleConf, ModuleId mid) {
        Collection resolved = (Collection)this.pendingConflicts.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            Iterator iter = resolved.iterator();
            while (iter.hasNext()) {
                IvyNode node = (IvyNode)iter.next();
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection conflicts) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.pendingConflicts.put(moduleIdConf, new HashSet(conflicts));
    }

    private static final class ModuleIdConf {
        private ModuleId moduleId;
        private String conf;

        public ModuleIdConf(ModuleId mid, String conf) {
            if (mid == null) {
                throw new NullPointerException("mid cannot be null");
            }
            if (conf == null) {
                throw new NullPointerException("conf cannot be null");
            }
            this.moduleId = mid;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final ModuleId getModuleId() {
            return this.moduleId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleIdConf)) {
                return false;
            }
            return this.getModuleId().equals(((ModuleIdConf)obj).getModuleId()) && this.getConf().equals(((ModuleIdConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getModuleId().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }
    }

    public static class EvictionData {
        private IvyNode parent;
        private ConflictManager conflictManager;
        private Collection selected;
        private String rootModuleConf;
        private String detail;

        public EvictionData(String rootModuleConf, IvyNode parent, ConflictManager conflictManager, Collection selected) {
            this(rootModuleConf, parent, conflictManager, selected, null);
        }

        public EvictionData(String rootModuleConf, IvyNode parent, ConflictManager conflictManager, Collection selected, String detail) {
            this.rootModuleConf = rootModuleConf;
            this.parent = parent;
            this.conflictManager = conflictManager;
            this.selected = selected;
            this.detail = detail;
        }

        public String toString() {
            if (this.selected != null) {
                return this.selected + " in " + this.parent + (this.detail == null ? "" : " " + this.detail) + " (" + this.conflictManager + ") [" + this.rootModuleConf + "]";
            }
            return "transitively [" + this.rootModuleConf + "]";
        }

        public ConflictManager getConflictManager() {
            return this.conflictManager;
        }

        public IvyNode getParent() {
            return this.parent;
        }

        public Collection getSelected() {
            return this.selected;
        }

        public String getRootModuleConf() {
            return this.rootModuleConf;
        }

        public boolean isTransitivelyEvicted() {
            return this.parent == null;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

