/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ftpserver.command.ABOR;
import org.apache.ftpserver.command.ACCT;
import org.apache.ftpserver.command.APPE;
import org.apache.ftpserver.command.AUTH;
import org.apache.ftpserver.command.CDUP;
import org.apache.ftpserver.command.CWD;
import org.apache.ftpserver.command.DELE;
import org.apache.ftpserver.command.EPRT;
import org.apache.ftpserver.command.EPSV;
import org.apache.ftpserver.command.FEAT;
import org.apache.ftpserver.command.HELP;
import org.apache.ftpserver.command.LANG;
import org.apache.ftpserver.command.LIST;
import org.apache.ftpserver.command.MD5;
import org.apache.ftpserver.command.MDTM;
import org.apache.ftpserver.command.MKD;
import org.apache.ftpserver.command.MLSD;
import org.apache.ftpserver.command.MLST;
import org.apache.ftpserver.command.MODE;
import org.apache.ftpserver.command.NLST;
import org.apache.ftpserver.command.NOOP;
import org.apache.ftpserver.command.OPTS;
import org.apache.ftpserver.command.PASS;
import org.apache.ftpserver.command.PASV;
import org.apache.ftpserver.command.PBSZ;
import org.apache.ftpserver.command.PORT;
import org.apache.ftpserver.command.PROT;
import org.apache.ftpserver.command.PWD;
import org.apache.ftpserver.command.QUIT;
import org.apache.ftpserver.command.REIN;
import org.apache.ftpserver.command.REST;
import org.apache.ftpserver.command.RETR;
import org.apache.ftpserver.command.RMD;
import org.apache.ftpserver.command.RNFR;
import org.apache.ftpserver.command.RNTO;
import org.apache.ftpserver.command.SITE;
import org.apache.ftpserver.command.SIZE;
import org.apache.ftpserver.command.STAT;
import org.apache.ftpserver.command.STOR;
import org.apache.ftpserver.command.STOU;
import org.apache.ftpserver.command.STRU;
import org.apache.ftpserver.command.SYST;
import org.apache.ftpserver.command.TYPE;
import org.apache.ftpserver.command.USER;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.Command;
import org.apache.ftpserver.interfaces.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandFactory
implements CommandFactory,
Component {
    private static final Logger LOG = LoggerFactory.getLogger((Class)DefaultCommandFactory.class);
    private HashMap commandMap = new HashMap();

    public void configure(Configuration conf) throws FtpException {
        this.commandMap.put("ABOR", new ABOR());
        this.commandMap.put("ACCT", new ACCT());
        this.commandMap.put("APPE", new APPE());
        this.commandMap.put("AUTH", new AUTH());
        this.commandMap.put("CDUP", new CDUP());
        this.commandMap.put("CWD", new CWD());
        this.commandMap.put("DELE", new DELE());
        this.commandMap.put("EPRT", new EPRT());
        this.commandMap.put("EPSV", new EPSV());
        this.commandMap.put("FEAT", new FEAT());
        this.commandMap.put("HELP", new HELP());
        this.commandMap.put("LANG", new LANG());
        this.commandMap.put("LIST", new LIST());
        this.commandMap.put("MD5", new MD5());
        this.commandMap.put("MMD5", new MD5());
        this.commandMap.put("MDTM", new MDTM());
        this.commandMap.put("MLST", new MLST());
        this.commandMap.put("MKD", new MKD());
        this.commandMap.put("MLSD", new MLSD());
        this.commandMap.put("MODE", new MODE());
        this.commandMap.put("NLST", new NLST());
        this.commandMap.put("NOOP", new NOOP());
        this.commandMap.put("OPTS", new OPTS());
        this.commandMap.put("PASS", new PASS());
        this.commandMap.put("PASV", new PASV());
        this.commandMap.put("PBSZ", new PBSZ());
        this.commandMap.put("PORT", new PORT());
        this.commandMap.put("PROT", new PROT());
        this.commandMap.put("PWD", new PWD());
        this.commandMap.put("QUIT", new QUIT());
        this.commandMap.put("REIN", new REIN());
        this.commandMap.put("REST", new REST());
        this.commandMap.put("RETR", new RETR());
        this.commandMap.put("RMD", new RMD());
        this.commandMap.put("RNFR", new RNFR());
        this.commandMap.put("RNTO", new RNTO());
        this.commandMap.put("SITE", new SITE());
        this.commandMap.put("SIZE", new SIZE());
        this.commandMap.put("STAT", new STAT());
        this.commandMap.put("STOR", new STOR());
        this.commandMap.put("STOU", new STOU());
        this.commandMap.put("STRU", new STRU());
        this.commandMap.put("SYST", new SYST());
        this.commandMap.put("TYPE", new TYPE());
        this.commandMap.put("USER", new USER());
        Configuration sconf = conf.subset("command");
        if (sconf == null || sconf.isEmpty()) {
            return;
        }
        Iterator cmds = sconf.getKeys();
        if (cmds == null) {
            return;
        }
        while (cmds.hasNext()) {
            String cmdName = (String)cmds.next();
            String cmdClass = sconf.getString(cmdName, null);
            if (cmdClass == null || cmdClass.equals("")) {
                throw new FtpException("Command not found :: " + cmdName);
            }
            try {
                Class<?> clazz = Class.forName(cmdClass);
                Command cmd = (Command)clazz.newInstance();
                this.commandMap.put(cmdName, cmd);
            }
            catch (Exception ex) {
                LOG.error("DefaultCommandFactory.configure()", (Throwable)ex);
                throw new FtpException("DefaultCommandFactory.configure()", (Throwable)ex);
            }
        }
    }

    public Command getCommand(String cmdName) {
        if (cmdName == null || cmdName.equals("")) {
            return null;
        }
        return (Command)this.commandMap.get(cmdName);
    }

    public void dispose() {
        this.commandMap.clear();
    }
}

