/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.File;
import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MKD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)MKD.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        FtpletEnum ftpletRet;
        session.resetState();
        FtpServerContext serverContext = connection.getServerContext();
        String fileName = request.getArgument();
        if (fileName == null || fileName.indexOf(File.pathSeparatorChar) > -1) {
            out.write(FtpReplyUtil.translate(session, 501, "MKD", null));
            return;
        }
        Ftplet ftpletContainer = serverContext.getFtpletContainer();
        try {
            ftpletRet = ftpletContainer.onMkdirStart((FtpSession)session, request, out);
        }
        catch (Exception e) {
            this.LOG.debug("Ftplet container threw exception", (Throwable)e);
            ftpletRet = FtpletEnum.RET_DISCONNECT;
        }
        if (ftpletRet == FtpletEnum.RET_SKIP) {
            return;
        }
        if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
            serverContext.getConnectionManager().closeConnection(connection);
            return;
        }
        FileObject file = null;
        try {
            file = session.getFileSystemView().getFileObject(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            out.write(FtpReplyUtil.translate(session, 550, "MKD.invalid", fileName));
            return;
        }
        fileName = file.getFullName();
        if (!file.hasWritePermission()) {
            out.write(FtpReplyUtil.translate(session, 550, "MKD.permission", fileName));
            return;
        }
        if (file.doesExist()) {
            out.write(FtpReplyUtil.translate(session, 550, "MKD.exists", fileName));
            return;
        }
        if (file.mkdir()) {
            out.write(FtpReplyUtil.translate(session, 250, "MKD", fileName));
            String userName = session.getUser().getName();
            this.LOG.info("Directory create : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)connection.getServerContext().getFtpStatistics();
            ftpStat.setMkdir(connection, file);
            try {
                ftpletRet = ftpletContainer.onMkdirEnd((FtpSession)session, request, out);
            }
            catch (Exception e) {
                this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                ftpletRet = FtpletEnum.RET_DISCONNECT;
            }
            if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                serverContext.getConnectionManager().closeConnection(connection);
                return;
            }
        } else {
            out.write(FtpReplyUtil.translate(session, 550, "MKD", fileName));
        }
    }
}

