/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.ftpserver.FtpRequestImpl;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.IODataConnectionFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.FtpServerSession;
import org.apache.ftpserver.interfaces.Ssl;
import org.apache.ftpserver.listener.AbstractConnection;
import org.apache.ftpserver.listener.ConnectionObserver;
import org.apache.ftpserver.listener.FtpProtocolHandler;
import org.apache.ftpserver.listener.io.IOFtpResponseOutput;
import org.apache.ftpserver.listener.io.IOListener;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOConnection
extends AbstractConnection
implements Runnable {
    private final Logger LOG = LoggerFactory.getLogger((Class)IOConnection.class);
    private Socket controlSocket;
    private IOFtpResponseOutput writer;
    private BufferedReader reader;
    private boolean isConnectionClosed;
    private FtpProtocolHandler protocolHandler;

    public IOConnection(FtpServerContext serverContext, Socket controlSocket, IOListener listener) throws IOException {
        super(serverContext);
        this.controlSocket = controlSocket;
        this.protocolHandler = new FtpProtocolHandler(serverContext);
        this.ftpSession = new FtpSessionImpl(serverContext);
        this.ftpSession.setClientAddress(this.controlSocket.getInetAddress());
        this.ftpSession.setServerAddress(this.controlSocket.getLocalAddress());
        this.ftpSession.setServerPort(this.controlSocket.getLocalPort());
        this.ftpSession.setListener(listener);
        IODataConnectionFactory dataCon = new IODataConnectionFactory(this.serverContext, this.ftpSession);
        dataCon.setServerControlAddress(controlSocket.getLocalAddress());
        this.ftpSession.setFtpDataConnection(dataCon);
        if (this.controlSocket instanceof SSLSocket) {
            SSLSocket sslControlSocket = (SSLSocket)this.controlSocket;
            try {
                this.ftpSession.setClientCertificates(sslControlSocket.getSession().getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        this.writer = new IOFtpResponseOutput(this.controlSocket);
    }

    public void setObserver(ConnectionObserver observer) {
        IOFtpResponseOutput writer = this.writer;
        if (writer != null) {
            writer.setObserver(observer);
        }
        super.setObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.ftpSession == null) {
            return;
        }
        if (this.serverContext == null) {
            return;
        }
        try {
            this.protocolHandler.onConnectionOpened(this, this.ftpSession, this.writer);
            this.reader = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream(), "UTF-8"));
            do {
                this.notifyObserver();
                String commandLine = this.reader.readLine();
                if (commandLine == null) {
                    break;
                }
                if ((commandLine = commandLine.trim()).equals("")) continue;
                this.spyRequest(commandLine);
                FtpRequestImpl request = new FtpRequestImpl(commandLine);
                this.protocolHandler.onRequestReceived(this, this.ftpSession, this.writer, request);
            } while (!this.isConnectionClosed);
        }
        catch (SocketException ex) {
        }
        catch (SSLException ex) {
            this.LOG.warn("The client did not initiate the SSL connection correctly", (Throwable)ex);
        }
        catch (Exception ex) {
            this.LOG.warn("Client error, closing session", (Throwable)ex);
        }
        finally {
            if (!this.isConnectionClosed) {
                this.serverContext.getConnectionManager().closeConnection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Socket controlSocket;
        IOConnection iOConnection = this;
        synchronized (iOConnection) {
            if (this.isConnectionClosed) {
                return;
            }
            this.isConnectionClosed = true;
        }
        this.protocolHandler.onConnectionClosed(this, this.ftpSession, this.writer);
        BufferedReader reader = this.reader;
        if (reader != null) {
            IoUtils.close(reader);
            reader = null;
        }
        if ((controlSocket = this.controlSocket) != null) {
            try {
                controlSocket.close();
            }
            catch (Exception ex) {
                this.LOG.warn("RequestHandler.close()", (Throwable)ex);
            }
            controlSocket = null;
        }
    }

    public void afterSecureControlChannel(FtpServerSession ftpSession, String protocol) throws Exception {
        Ssl ssl = ftpSession.getListener().getSsl();
        if (ssl == null) {
            throw new FtpException("Socket factory SSL not configured");
        }
        Socket ssoc = ssl.createSocket(protocol, this.controlSocket, false);
        this.reader = new BufferedReader(new InputStreamReader(ssoc.getInputStream(), "UTF-8"));
        this.writer.setControlSocket(ssoc);
        this.controlSocket = ssoc;
    }

    public void beforeSecureControlChannel(FtpServerSession ftpSession, String type) throws Exception {
    }
}

