/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.configuration.JBossWSServerCXFConfigurer;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.spring.handler.NamespaceHandlerResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class BusHolder {
    private static final Logger log = Logger.getLogger(BusHolder.class);
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    private boolean configured = false;
    protected BusApplicationContext ctx;
    protected List<GenericApplicationContext> additionalCtx = new LinkedList<GenericApplicationContext>();
    protected Bus bus;

    private BusHolder() {
    }

    public static BusHolder create(URL location) {
        BusHolder holder = new BusHolder();
        holder.createBus(location);
        return holder;
    }

    public static BusHolder create(Bus bus) {
        BusHolder holder = new BusHolder();
        holder.setBus(bus);
        holder.setContext((BusApplicationContext)bus.getExtension(BusApplicationContext.class));
        return holder;
    }

    public void configure(URL jbossCxfXml, SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer) throws IOException {
        if (this.configured) {
            throw new IllegalStateException("Underlying bus is already configured for JBossWS use!");
        }
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        BusHolder.setSoapTransportFactory(this.bus, soapTransportFactory);
        BusHolder.setResourceResolver(this.bus, resolver);
        if (jbossCxfXml != null) {
            this.additionalCtx.add(BusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, jbossCxfXml));
        }
        this.configured = true;
    }

    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher) {
        ApplicationContext ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        JBossWSServerCXFConfigurer serverConfigurer = new JBossWSServerCXFConfigurer(ctx);
        serverConfigurer.setBindingCustomization(customization);
        serverConfigurer.setWsdlPublisher(wsdlPublisher);
        return serverConfigurer;
    }

    public void close() {
        for (GenericApplicationContext gac : this.additionalCtx) {
            gac.destroy();
        }
    }

    protected void createBus(URL location) {
        block4: {
            this.bus = new JBossWSSpringBusFactory().createBus();
            this.ctx = (BusApplicationContext)this.bus.getExtension(BusApplicationContext.class);
            if (location != null) {
                try {
                    this.additionalCtx.add(BusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, location));
                }
                catch (IOException e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("Could not load additional config from location: " + location), (Throwable)e);
                }
            }
        }
        ServletTransportFactory factory = new ServletTransportFactory(this.bus);
        for (String s : factory.getTransportIds()) {
            this.registerTransport((DestinationFactory)factory, s);
        }
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setSoapTransportFactory(Bus bus, SoapTransportFactory factory) {
        if (factory != null) {
            DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
            factory.setBus(bus);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)factory);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap12/", (DestinationFactory)factory);
        }
    }

    protected static GenericApplicationContext loadAdditionalConfig(ApplicationContext ctx, URL locationUrl) throws IOException {
        if (locationUrl == null) {
            throw new IllegalArgumentException("Cannot load additional config from null location!");
        }
        InputStream is = locationUrl.openStream();
        GenericApplicationContext childCtx = new GenericApplicationContext(ctx);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)childCtx);
        reader.setValidationMode(3);
        reader.setNamespaceHandlerResolver((org.springframework.beans.factory.xml.NamespaceHandlerResolver)new NamespaceHandlerResolver());
        reader.loadBeanDefinitions((Resource)new InputStreamResource(is));
        childCtx.refresh();
        return childCtx;
    }

    private void registerTransport(DestinationFactory factory, String namespace) {
        ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).registerDestinationFactory(namespace, factory);
    }

    public Bus getBus() {
        return this.bus;
    }

    private void setBus(Bus bus) {
        this.bus = bus;
    }

    private void setContext(BusApplicationContext ctx) {
        this.ctx = ctx;
    }
}

