/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.config.BackGroundRegistration;
import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.config.XRegistration;
import org.apache.log4j.Logger;
import org.uddi.api_v3.BusinessService;

public class UDDIClerkManager {
    private static Logger log = Logger.getLogger(UDDIClerkManager.class);
    private ClientConfig clientConfig = null;

    public UDDIClerkManager(String configurationFile) throws ConfigurationException {
        this.clientConfig = new ClientConfig(configurationFile);
    }

    public void stop() throws ConfigurationException {
        log.info((Object)("Stopping UDDI Clerks for manager " + this.clientConfig.getManagerName()));
        this.releaseResources();
        UDDIClientContainer.removeClerkManager(this.getName());
        log.info((Object)("UDDI Clerks shutdown completed for manager " + this.clientConfig.getManagerName()));
    }

    private void releaseResources() {
        this.unRegisterAnnotatedServices();
    }

    public void start() throws ConfigurationException {
        BackGroundRegistration runnable = new BackGroundRegistration(this);
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void restart() throws ConfigurationException {
        this.stop();
        this.start();
    }

    public void saveClerkAndNodeInfo() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            UDDIClerk homeClerk = null;
            for (UDDIClerk clerk : uddiClerks.values()) {
                if (!clerk.getUDDINode().isHomeJUDDI()) continue;
                homeClerk = clerk;
            }
            if (homeClerk != null) {
                int numberOfHomeJUDDIs = 0;
                for (UDDINode uddiNode : this.clientConfig.getUDDINodes().values()) {
                    if (uddiNode.isHomeJUDDI()) {
                        ++numberOfHomeJUDDIs;
                    }
                    homeClerk.saveNode(uddiNode.getApiNode());
                }
                if (numberOfHomeJUDDIs == 1) {
                    for (UDDIClerk clerk : this.clientConfig.getUDDIClerks().values()) {
                        homeClerk.saveClerk(clerk);
                    }
                } else {
                    log.error((Object)("The client config needs to have one homeJUDDI node and found " + numberOfHomeJUDDIs));
                }
            } else {
                log.info((Object)"No home clerk found.");
            }
        }
    }

    public void xRegister() {
        log.info((Object)"Starting cross registration...");
        Set<XRegistration> xBusinessRegistrations = this.clientConfig.getXBusinessRegistrations();
        for (XRegistration xRegistration : xBusinessRegistrations) {
            xRegistration.xRegisterBusiness();
        }
        Set<XRegistration> xServiceBindingRegistrations = this.clientConfig.getXServiceBindingRegistrations();
        for (XRegistration xRegistration : xServiceBindingRegistrations) {
            xRegistration.xRegisterServiceBinding();
        }
        log.info((Object)"Cross registration completed");
    }

    public void registerAnnotatedServices() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk uddiClerk : uddiClerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(uddiClerk.getClassWithAnnotations(), uddiClerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    log.info((Object)("Node=" + uddiClerk.getUDDINode().getApiNode().getName()));
                    uddiClerk.register(businessService, uddiClerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public void unRegisterAnnotatedServices() {
        Map<String, UDDIClerk> clerks = this.clientConfig.getUDDIClerks();
        if (clerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk clerk : clerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(clerk.getClassWithAnnotations(), clerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    clerk.unRegister(businessService, clerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getName() {
        return this.clientConfig.getManagerName();
    }
}

