/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.log4j.Logger;

public class UDDIClientContainer {
    private static Logger log = Logger.getLogger(UDDIClientContainer.class);
    private static Map<String, UDDIClerkManager> managers = new HashMap<String, UDDIClerkManager>();

    public static UDDIClerkManager getUDDIClerkManager(String managerName) throws ConfigurationException {
        if (managers.containsKey(managerName)) {
            return managers.get(managerName);
        }
        if (managers.size() == 1 && managerName == null) {
            return managers.values().iterator().next();
        }
        UDDIClerkManager manager = new UDDIClerkManager(null);
        manager.start();
        UDDIClientContainer.addClerkManager(manager);
        return manager;
    }

    public static void addClerkManager(UDDIClerkManager manager) {
        managers.put(manager.getClientConfig().getManagerName(), manager);
    }

    public static void removeClerkManager(String managerName) throws ConfigurationException {
        if (managers.containsKey(managerName)) {
            managers.remove(managerName);
        } else if (managers.size() == 1 && managerName == null) {
            String name = managers.keySet().iterator().next();
            log.info((Object)("Removing " + name + " from UDDIClient."));
            managers.remove(name);
        } else {
            throw new ConfigurationException("Could not remove UDDIClerkManager for name " + managerName);
        }
    }

    public static String getDefaultTransportClass() throws ConfigurationException {
        UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(null);
        return manager.getClientConfig().getUDDINode("default").getProxyTransport();
    }
}

