/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class JAXWSTransport
extends Transport {
    public static final String UDDI_V3_SERVICE_NAMESPACE = "urn:uddi-org:v3_service";
    public static final String JUDDI_V3_SERVICE_NAMESPACE = "urn:juddi-apache-org:v3_service";
    public static final String INQUIRY_SERVICE = "UDDI_Inquiry_Port";
    public static final String SECURITY_SERVICE = "UDDI_Security_Port";
    public static final String PUBLISH_SERVICE = "UDDI_Publish_Port";
    public static final String SUBSCRIPTION_SERVICE = "UDDI_Subscription_Port";
    public static final String SUBSCRIPTION_LISTENER_SERVICE = "UDDI_SubscriptionListener_Port";
    public static final String CUSTODY_TRANSFER_SERVICE = "UDDI_CustodyTransfer_Port";
    public static final String PUBLISHER_SERVICE = "JUDDI_Api_Port";
    String nodeName = null;
    String managerName = null;
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public JAXWSTransport() {
        this.nodeName = "default";
    }

    public JAXWSTransport(String nodeName) {
        this.nodeName = nodeName;
    }

    public JAXWSTransport(String managerName, String nodeName) {
        this.managerName = managerName;
        this.nodeName = nodeName;
    }

    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        if (this.inquiryService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, INQUIRY_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.inquiryService = (UDDIInquiryPortType)service.getPort(UDDIInquiryPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        if (this.securityService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSecurityUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, SECURITY_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.securityService = (UDDISecurityPortType)service.getPort(UDDISecurityPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        if (this.publishService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, PUBLISH_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.publishService = (UDDIPublicationPortType)service.getPort(UDDIPublicationPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        if (this.subscriptionService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, SUBSCRIPTION_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.subscriptionService = (UDDISubscriptionPortType)service.getPort(UDDISubscriptionPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getSubscriptionListenerUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, SUBSCRIPTION_LISTENER_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)service.getPort(UDDISubscriptionListenerPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getCustodyTransferUrl();
                }
                QName qName = new QName(UDDI_V3_SERVICE_NAMESPACE, CUSTODY_TRANSFER_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.custodyTransferService = (UDDICustodyTransferPortType)service.getPort(UDDICustodyTransferPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        if (this.publisherService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(this.managerName);
                    endpointURL = manager.getClientConfig().getUDDINode(this.nodeName).getJuddiApiUrl();
                }
                QName qName = new QName(JUDDI_V3_SERVICE_NAMESPACE, PUBLISHER_SERVICE);
                Service service = Service.create((URL)new URL(endpointURL), (QName)qName);
                this.publisherService = (JUDDIApiPortType)service.getPort(JUDDIApiPortType.class);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}

