/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.example.provider;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.jboss.soa.dsp.InvocationAdapter;
import org.jboss.soa.dsp.MessageAdapter;
import org.jboss.soa.dsp.ServiceProvider;
import org.jboss.soa.dsp.ws.WSInvocationAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExampleServiceProvider implements ServiceProvider {

	public void invoke(InvocationAdapter<?> arg0) throws Exception {
		System.out.println("EXAMPLE SERVICE PROVIDER: invoke "+arg0);
		
		arg0.createFault(null, new QName("http://www.example.org", "ExampleFault"),
						new MessageAdapter() {

							public Map<String, Node> getHeaderParts() {
								return new HashMap<String,Node>();
							}

							public Element getMessage() {
								Element ret=null;
								
								try {
									ret = javax.xml.parsers.DocumentBuilderFactory.newInstance().
										newDocumentBuilder().newDocument().createElement("ExampleFaultDetails");
								} catch(Exception e) {
									e.printStackTrace();
								}
								
								return(ret);
							}

							public Element getPart(String arg0) {
								return null;
							}

							public void setHeaderPart(String arg0, Element arg1) {
							}

							public void setPart(String arg0, Element arg1) {
							}
			
		});
	}

}
