UPDATE ODE_SCHEMA_VERSION SET VERSION = 220;

DROP TABLE ODE_JOB;

CREATE TABLE ODE_JOB (
  jobid CHAR(64)  NOT NULL DEFAULT '',
  ts BIGINT  NOT NULL DEFAULT 0,
  nodeid varchar(64),
  scheduled bit  NOT NULL,
  transacted bit  NOT NULL,

  instanceId BIGINT,
  mexId varchar(255),
  processId varchar(255),
  type varchar(255),
  channel varchar(255),
  correlatorId varchar(255),
  correlationKeySet varchar(255),
  retryCount integer,
  inMem bit,
  detailsExt blob,

  PRIMARY KEY(jobid),
  INDEX IDX_ODE_JOB_TS(ts),
  INDEX IDX_ODE_JOB_NODEID(nodeid)
)
ENGINE=InnoDB;

COMMIT;

create table BPAF_EVENT (
        EID bigint not null auto_increment,
        ACTIVITY_DEFINITION_ID varchar(255),
        ACTIVITY_INSTANCE_ID varchar(255),
        ACTIVITY_NAME varchar(255),
        CURRENT_STATE varchar(255),
        PREVIOUS_STATE varchar(255),
        PROCESS_DEFINITION_ID varchar(255),
        PROCESS_INSTANCE_ID varchar(255),
        PROCESS_NAME varchar(255),
        SERVER_ID varchar(255),
        TIMESTAMP bigint,
        primary key (EID)
    ) ENGINE=InnoDB;;

create table BPAF_EVENT_DATA (
    TID bigint not null auto_increment,
    NAME varchar(255),
    VALUE varchar(255),
    EVENT_ID bigint,
    primary key (TID)
) ENGINE=InnoDB;;

alter table BPAF_EVENT_DATA
    add index FK3E83D1BCDA848C8 (EVENT_ID),
    add constraint FK3E83D1BCDA848C8
    foreign key (EVENT_ID)
    references BPAF_EVENT (EID);
