
UPDATE ODE_SCHEMA_VERSION SET VERSION = 220;

DROP TABLE ODE_JOB;

CREATE TABLE ODE_JOB (
  jobid varchar(64)  NOT NULL,
  ts numeric(19,0)  NOT NULL,
  nodeid varchar(64) null,
  scheduled tinyint  NOT NULL,
  transacted tinyint  NOT NULL,

  instanceId numeric(19,0) null,
  mexId varchar(255) null,
  processId varchar(255) null,
  type varchar(255) null,
  channel varchar(255) null,
  correlatorId varchar(255) null,
  correlationKeySet varchar(255) null,
  retryCount int null,
  inMem tinyint null,
  detailsExt image null,

  PRIMARY KEY(jobid));

CREATE INDEX IDX_ODE_JOB_TS ON ODE_JOB(ts);
CREATE INDEX IDX_ODE_JOB_NODEID ON ODE_JOB(nodeid);

create table BPAF_EVENT (
  EID numeric(19,0) identity not null,
  ACTIVITY_DEFINITION_ID varchar(255) null,
  ACTIVITY_INSTANCE_ID varchar(255) null,
  ACTIVITY_NAME varchar(255) null,
  CURRENT_STATE varchar(255) null,
  PREVIOUS_STATE varchar(255) null,
  PROCESS_DEFINITION_ID varchar(255) null,
  PROCESS_INSTANCE_ID varchar(255) null,
  PROCESS_NAME varchar(255) null,
  SERVER_ID varchar(255) null,
  TIMESTAMP numeric(19,0) null,
  primary key (EID)
);

create table BPAF_EVENT_DATA (
    TID numeric(19,0) identity not null,
    NAME varchar(255) null,
    VALUE varchar(255) null,
    EVENT_ID numeric(19,0) null,
    primary key (TID)
);

alter table BPAF_EVENT_DATA
    add constraint FK3E83D1BCDA848C8
    foreign key (EVENT_ID)
    references BPAF_EVENT;