/*
 * Copyright 2001-2010 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.juddi.xlt.test.benchmark;

import org.apache.juddi.xlt.action.SOAP.FindBusinessByName;
import org.apache.juddi.xlt.action.SOAP.GetAuthenticationToken;
import org.apache.juddi.xlt.util.AbstractUDDIClientTestCase;
import org.junit.Test;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.ServiceInfo;

import com.xceptance.xlt.api.data.DataProvider;

/**
 * This test case will query the jUDDI node and submit a random 
 * business name for which to search.
 *
 */
public class TFindBusinessBM extends AbstractUDDIClientTestCase
{
	/**
	 * This methode will get a random unique business name 
	 * from a list of previously published businesses and 
	 * try to find it in the juddi node.
	 * 
	 * @throws Throwable
	 */
	
	@Test
	public void findBusiness() throws Throwable
	{
		
		//Pick a company name from a previously generated list of business names.
		//The file BusinessNames.txt used here was generated by TRegisterBusiness.
		//It holds a list of unique strings that have already been entered in the
		//juddi node as business names (a different business per name). 
		DataProvider names = new DataProvider("default/BusinessNames.txt");
		String businessName = names.getRandomRow(); 
		
		//Get an AuthToken.
		GetAuthenticationToken getAuthenticationToken = new GetAuthenticationToken();
		getAuthenticationToken.run();
	
		//Find the random business by passing it's name and the AuthToken.
		FindBusinessByName findBusinessByName = new FindBusinessByName(getAuthenticationToken.getAuthenticationToken(), 
				businessName);
		findBusinessByName.run();
		
		//Print out the business that was found and the services published under it.
		for(BusinessInfo bi : findBusinessByName.getBusinessInfos().getBusinessInfo())
		{
			//Print out business name and key.
			System.out.println(bi.getName().get(0).getValue() + " - " + bi.getBusinessKey());
			for (ServiceInfo si : bi.getServiceInfos().getServiceInfo())
			{
				//Print out service name and key.
				System.out.println("	" + si.getName().get(0).getValue() + " - " + si.getBusinessKey());
			}
		}
	}	
}
