public interface SecurityService
{
    void configure() throws ConfigurationException;

    void authenticate(
        final SecurityConfig securityConfig, 
        final SecurityContext securityContext, 
        final AuthenticationRequest authRequest) 
        throws SecurityServiceException;

    boolean checkRolesAllowed(
        final List<String> rolesAllowed, 
        final SecurityContext securityContext);

    boolean isCallerInRole(
        final Subject subject, 
        final Principal role);

    void logout(final SecurityConfig securityConfig);

    void refreshSecurityConfig();
}
