/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;

/**
 * Cached event information for EndElement.
 */
public class ESBStaxEndElement extends ESBStaxXMLEvent implements EndElement
{
    private final QName name ;
    private final List<Namespace> namespaces ;

    public ESBStaxEndElement(final EndElement endElement)
    {
        super(endElement) ;
        name = endElement.getName() ;
        namespaces = ESBStaxNamespace.getNamespaces(endElement.getNamespaces()) ;
    }

    public QName getName()
    {
        return name ;
    }

    public Iterator<Namespace> getNamespaces()
    {
        return namespaces.iterator() ;
    }

    @Override
    public boolean isEndElement()
    {
        return true ;
    }

    @Override
    public EndElement asEndElement()
    {
        return this ;
    }
}
