/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.webservice;

import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext.Scope;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.internal.soa.esb.webservice.addressing.MAP;
import org.jboss.internal.soa.esb.webservice.addressing.MAPBuilder;
import org.jboss.internal.soa.esb.webservice.addressing.MAPBuilderFactory;


/**
 * The addressing handler for capturing the current 
 * @author kevin
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class AddressingHandler implements SOAPHandler<SOAPMessageContext>
{
    public Set<QName> getHeaders()
    {
        return null;
    }

    public void close(final MessageContext context)
    {
    }

    public boolean handleFault(final SOAPMessageContext context)
    {
        return true;
    }

    public boolean handleMessage(final SOAPMessageContext context)
    {
        final Boolean outbound = (Boolean)context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY) ;
        if (outbound == null)
        {
           throw new IllegalStateException("Cannot obtain required property: " + MessageContext.MESSAGE_OUTBOUND_PROPERTY) ;
        }

        if (outbound)
        {
            return handleResponse(context) ;
        }
        else
        {
            return handleRequest(context) ;
        }
    }
    
    private boolean handleRequest(final SOAPMessageContext context)
    {
        final MAP props = MAPBuilderFactory.getInstance().getBuilderInstance().inboundMap(context) ;
        AddressingContext.setAddressingProperties(props) ;
        
        return true ;
    }
    
    private boolean handleResponse(final SOAPMessageContext context)
    {
        final MAP props = AddressingContext.getAddressingProperties() ;
        if (props != null)
        {
            props.installOutboundMapOnServerSide(context, props);
            context.setScope(MAPBuilderFactory.getInstance().getBuilderInstance().newConstants().getServerAddressingPropertiesOutbound(), Scope.APPLICATION);
        }
        return true ;
    }
}
