/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/*
 * Copyright (c) 2002, 2003, Arjuna Technologies Limited.
 *
 * XMLUtil.java
 */

package org.jboss.soa.esb.addressing;

import javax.xml.namespace.QName;

public class XMLUtil
{
    // WS-Addr

    public static final String WSA_PREFIX = "wsa";
    public static final String WSA_NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    public static final String ENDPOINT_REFERENCE_TAG         = "EndpointReference";
    public static final QName  QNAME_ENDPOINT_REFERENCE_TAG   = new QName(WSA_NAMESPACE_URI, "EndpointReference", WSA_PREFIX);
    public static final String MESSAGE_IDENTIFIER_TAG         = "MessageID";
    public static final QName  QNAME_MESSAGE_IDENTIFIER_TAG   = new QName(WSA_NAMESPACE_URI, "MessageID", WSA_PREFIX);
    public static final String REFERENCE_PROPERTIES_TAG       = "ReferenceProperties";
    public static final QName  QNAME_REFERENCE_PROPERTIES_TAG = new QName(WSA_NAMESPACE_URI, "ReferenceProperties", WSA_PREFIX);
    public static final String REFERENCE_PARAMETERS_TAG       = "ReferenceParameters";
    public static final QName  QNAME_REFERENCE_PARAMETERS_TAG = new QName(WSA_NAMESPACE_URI, "ReferenceParameters", WSA_PREFIX);
    public static final String REPLY_TO_TAG                   = "ReplyTo";
    public static final QName  QNAME_REPLY_TO_TAG             = new QName(WSA_NAMESPACE_URI, "ReplyTo", WSA_PREFIX);
    public static final String FROM_TAG                       = "From";
    public static final QName  QNAME_FROM_TAG                 = new QName(WSA_NAMESPACE_URI, "From", WSA_PREFIX);

    public static final String TO_TAG                   = "To";
    public static final QName  QNAME_TO_TAG             =  new QName(WSA_NAMESPACE_URI, "To", WSA_PREFIX);
    public static final String ADDRESS_TAG              = "Address";
    public static final QName  QNAME_ADDRESS_TAG        = new QName(WSA_NAMESPACE_URI, "Address", WSA_PREFIX);
    public static final String ACTION_TAG               = "Action";
    public static final QName  QNAME_ACTION_TAG         = new QName(WSA_NAMESPACE_URI, "Action", WSA_PREFIX);
    public static final String RELATES_TO_TAG           = "RelatesTo";
    public static final QName  QNAME_RELATES_TO_TAG     = new QName(WSA_NAMESPACE_URI, "RelatesTo", WSA_PREFIX);
    public static final String FAULT_TO_TAG             = "FaultTo";
    public static final QName  QNAME_FAULT_TO_TAG       = new QName(WSA_NAMESPACE_URI, "FaultTo", WSA_PREFIX);
    
    // JBossESB

    public static final String JBOSSESB_PREFIX        = "jbossesb";
    public static final String JBOSSESB_NAMESPACE_URI = "http://schemas.jboss.com/ws/2007/01/jbossesb";

    public static final String INSTANCE_IDENTIFIER_TAG = "InstanceIdentifier";

    public static final String UNKNOWNERROR_ERROR_CODE = "UnknownError";
    
    // XML Namespace
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/" ;
    public static final String XMLNS_PREFIX = "xmlns:" ;
}
