package org.jboss.soa.esb.addressing.eprs;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */


/**
 * This class represents the endpoint reference for services.
 */

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;

/**
 * A helper class for using HTTP style EPRs. Simply create instances of this
 * class instead of the base EPR.
 * 
 * @author marklittle
 *
 */
public class HTTPEpr extends EPR
{

	public HTTPEpr (EPR epr)
	{
		super(epr);
	}
	
	public HTTPEpr (EPR epr, Element header)
	{
		super(epr);
	}
	/**
	 * Construct the HTTP EPR using the specified URL.
	 * @param url
	 * @throws URISyntaxException
	 * @deprecated
	 */
	public HTTPEpr (URL url) throws URISyntaxException
	{
		this(url.toURI());
	}

       /**
         * Construct the HTTP EPR using the specified URI.
         * @param uri
         * @throws URISyntaxException
         */
        public HTTPEpr (URI uri)
        {
                super(uri, type().toString());
        }

	public HTTPEpr (String url) throws URISyntaxException
	{
		this(new URI(url));
	}
	
	/**
	 * Set the URL for this endpoint.
	 * 
	 * @param url the address.
	 * @deprecated
	 */
	
	public final void setURL (URL url)
	{
		super.setAddr(new PortReference(url.toString()));
		setType(type().toString()) ;
	}
	
	/**
	 * Get the URL address.
	 * 
	 * @return the address.
	 * @deprecated
	 */
	
	public final URL getURL ()
	{
            try
            {
		return new URL(super.getAddr().getAddress());
            }
            catch (Exception ex)
            {
                _logger.warn("Unexpected parsing exception!", ex);
                
                return null;
            }
	}
	
	public String toString ()
	{
		return "HTTPEpr [ "+super.getAddr().extendedToString()+" ]";
	}

	public EPR copy ()
	{
	    return new HTTPEpr(this);
	}
	
	public static final URI type ()
	{
	    return _type;
	}

	private static URI _type;
	
	static
	{
	    try
		{
		    _type = new URI("urn:jboss/esb/epr/type/http");
		}
		catch (Exception ex)
		{
		    ex.printStackTrace();
		    
		    throw new ExceptionInInitializerError(ex.toString());
		}
	}
} 
