package org.jboss.soa.esb.message;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */


/**
 * This interface extends the generic Message interface to provide a mechanism
 * whereby implementations can take control over pass by value messaging.
 * The implementation will be provided with an opportunity to create the
 * reference message.
 *
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */

public interface ByReferenceMessage extends Message
{
    /**
     * Create the message used for pass by reference semantics.
     * @return the referencable message.
     */
    public Message reference() ;
}
