/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services;

import java.io.Serializable;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.notification.NotificationException;

/**
 * Use this interface to group all methods that can be useful to trigger events
 * that can be caught by listeners, within or outside of the Rosetta framework
 * 
 * @author Esteban
 * 
 */
public interface NotificationManager
{

	// REVIEW: Add some Javadoc for this interface!!!
	/**
	 * public void sendNotifications(ConfigTree p_oP, Serializable p_o)
	 * 
	 * @param p_oP
	 *            ConfigTree - A serialized NotificationList object (as a
	 *            ConfigTree)
	 * @param p_o
	 *            The Serializable object that will be sent to all the
	 *            NotificationTarget objects contained in the NotificationList
	 * 
	 * <p/>Implementations of this interface will be responsible of sending the
	 * Serializable (arg 1) to destinations determined by each
	 * NotificationTarget contained in the NotificationList represented by arg
	 * 0. <p/>Please see org.jboss.soa.esb.notification package for existing
	 * classes that extend NotificationTarget (Files, Queues, Topics,
	 * SqlTable...)
	 * 
	 * <p/> Invoking processes are responsible to provide dynamic content of
	 * notification <p/> The NotificationTarget objects can define 'static'
	 * content for (suc as contents of certain columns in SQL, or message
	 * properties for JMS notification targets, etc.
	 */
	public void sendNotifications (ConfigTree p_oP, Serializable p_o)
			throws ConfigurationException, NotificationException;

	public void sendNotifications (Serializable p_o)
			throws NotificationException;
} // ____________________________________________________________________________
