/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.services.routing.cbr;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.util.ClassUtil;
/**
 * Returns an instance of the Registry.
 *
 * @author kurt.stam@redhat.com
 *
 */
public class ContentBasedRouterFactory {
    private static Logger logger = Logger.getLogger(ContentBasedRouterFactory.class);

    public static ContentBasedRouter getRouter(String className) throws MessageRouterException
    {
	ContentBasedRouter cbr = null;
        logger.log(Level.DEBUG, "Going to load " + className);
    try {
        // instruct class loader to load the Content Based  Router Implementation
        Class cbrClass = ClassUtil.forName(className, ContentBasedRouterFactory.class);
        // Try to get an instance of the CBR
        cbr = (ContentBasedRouter) cbrClass.newInstance();
    } catch (ClassNotFoundException cnfex) {
        throw new MessageRouterException("Content Based Router Implementation=" + className + " not found", cnfex);
    } catch (Exception e) {
    	throw new MessageRouterException(className + " invokation problem. " + e.getLocalizedMessage(), e);
    		}
    		return cbr;
    	}
    }
