/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import java.util.HashMap;
import java.util.Map;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.services.security.SecurityConfig.Builder;

/**
 * This util class provides methods to extract information from a security
 * configuration. <p/>
 *
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 * @since 4.4.
 *
 */
public class SecurityConfigUtil
{
	private SecurityConfigUtil() { }

	public static SecurityConfig createSecurityConfig(final ConfigTree securityFragment)
	{
		final String moduleName = securityFragment.getAttribute(ListenerTagNames.MODULE_NAME_TAG);

		Builder builder = new SecurityConfig.Builder(moduleName);
		builder.runAs(securityFragment.getAttribute(ListenerTagNames.RUN_AS_TAG));
		builder.useCallerIdentity(securityFragment.getAttribute(ListenerTagNames.USE_CALLERS_IDENTIDY_TAG));
		builder.rolesAllowed(securityFragment.getAttribute(ListenerTagNames.ROLES_ALLOWED));
		builder.callBackhandler(securityFragment.getAttribute(ListenerTagNames.CALLBACK_HANDLER_TAG));

		ConfigTree[] children = securityFragment.getChildren("property");
		for (ConfigTree configTree : children)
		{
			String propertyName = configTree.getAttribute("name");
			String propertyValue = configTree.getAttribute("value");
			builder.property(propertyName, propertyValue);
		}
		return builder.build();
	}
}
