/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.principals;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/**
 * A Role is a collection/group of Principals.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class Group implements java.security.acl.Group, Serializable
{
	private static final long serialVersionUID = 1L;
	public static final String ROLES_GROUP_NAME = "Roles";
	
	private final String groupName;
	private final Set<Principal> members = new HashSet<Principal>(); 

	public Group(final String groupName)
	{
		if ( groupName == null )
			throw new NullPointerException("groupName argument must not be null");
		
		this.groupName = groupName;
	}

	public String getName()
	{
		return groupName;
	}
	
	public String toString()
	{
		return "[groupName=" + groupName + ", members=" + members + "]";
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if(!(obj instanceof Group))
			return false;
		
		Group other = (Group) obj; 
		return other.groupName.equals(groupName) &&
		other.members.equals(members);
	}

	@Override
	public int hashCode()
	{
		int hash = 17;
		hash = 31 * hash + groupName == null ? 0 : groupName.hashCode();
		return hash;
	}

	public boolean addMember(Principal user)
	{
		return members.add(user);
	}

	public boolean isMember(Principal user)
	{
		return members.contains(user);
	}

	public Enumeration<? extends Principal> members()
	{
		return Collections.enumeration(members);
	}

	public boolean removeMember(Principal user)
	{
		return members.remove(user);
	}
	
}
