/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners;

import java.net.URI;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.rosetta.pooling.MockTransactionStrategy;

import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.listeners.RegistryUtil;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.listeners.message.MissingServiceException;
import org.jboss.soa.esb.listeners.message.ResponseTimeoutException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import com.arjuna.common.util.propertyservice.PropertyManager;

public class ServiceInvokerErrorUnitTest extends TestCase
{
	private String redeliverDlsServiceOn ;
	private EPR timeoutEPR ;

	protected final void setUp() throws Exception
	{
		MockCourierFactory.install() ;
		MockRegistry.install() ;
		timeoutEPR = new EPR(new URI("timeout")) ;
		MockRegistry.register("timeout", "service", timeoutEPR, new MockCourier(true)) ;
		final PropertyManager propertyManager = ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE) ;
		if (propertyManager != null)
		{
			redeliverDlsServiceOn = propertyManager.getProperty(Environment.REDELIVER_DLS_SERVICE_ON) ;
			propertyManager.setProperty(Environment.REDELIVER_DLS_SERVICE_ON, "false") ;
			propertyManager.setProperty(Environment.SI_ROLLBACK_ON_EXCEPTION, "true");
		}
		
		MockTransactionStrategy.isActive = true;
		MockTransactionStrategy.transactionObject = new String("foo");
		try {
			TransactionStrategy.setTransactionStrategy(new MockTransactionStrategy());
		} catch (Exception e) {
		}
	}

	protected final void tearDown()
	{

		TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
		try { 
			txStrategy.rollbackOnly();
			txStrategy.terminate();
		} catch (Exception e) {
		}
			
		final PropertyManager propertyManager = ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE) ;
		if (propertyManager != null)
		{
			if (redeliverDlsServiceOn == null)
			{
				propertyManager.removeProperty(Environment.REDELIVER_DLS_SERVICE_ON) ;
			}
			else
			{
				propertyManager.setProperty(Environment.REDELIVER_DLS_SERVICE_ON, redeliverDlsServiceOn) ;
			}
		}
		MockRegistry.uninstall();
		MockCourierFactory.uninstall() ;
	}

	public void testRollbackOnExceptionOn() throws Exception
	{
		final PropertyManager propertyManager = ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE) ;
		propertyManager.setProperty(Environment.SI_ROLLBACK_ON_EXCEPTION, "true");
		
		Message message = MessageFactory.getInstance().getMessage();
		final String category = "test" ;
		final String name = "qwerty" ;

		int foo = 0;
		try
		{
            ServiceInvoker invoker = new ServiceInvoker("foo", "bar");
            invoker.deliverAsync(message);
			fail();
		}
		catch (MessageDeliverException ex)
		{
			fail();
		}
		catch (RuntimeException re) {
			foo = 1;
		}

		assertEquals(foo, 1);		
	}
	
	public void testRollbackOnExceptionOff() throws Exception
	{
		final PropertyManager propertyManager = ModulePropertyManager.getPropertyManager(ModulePropertyManager.CORE_MODULE) ;
		propertyManager.setProperty(Environment.SI_ROLLBACK_ON_EXCEPTION, "false");
		
		Message message = MessageFactory.getInstance().getMessage();
		final String category = "test" ;
		final String name = "qwerty" ;

		try
		{
            ServiceInvoker invoker = new ServiceInvoker("foo", "bar");
            invoker.deliverAsync(message);
			fail();
		}
		catch (MessageDeliverException ex)
		{
		}

		final EPR epr = new EPR(new URI(category + name));

		MockRegistry.register(category, name, epr, new MockCourier(true)) ;

		{
			ServiceInvoker invoker = new ServiceInvoker(category, name);
			invoker.deliverAsync(message);
		}

		RegistryUtil.unregister(category, name, epr);
		
		try
		{
			ServiceInvoker invoker = new org.jboss.soa.esb.client.ServiceInvoker(category, name);
			invoker.deliverAsync(message);
		}
		catch (final MissingServiceException mse) {} // expected
	}
}
