/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.config;

import java.io.File;

import junit.framework.TestCase;

import org.jboss.deployment.DeploymentException;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.listeners.config.model.ModelAdapter;

/**
 * Unit test for WebGatewayBuilder. 
 * 
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public class WebGatewayBuilderUnitTest extends TestCase {

    public void test() throws ConfigurationException, DeploymentException {
        String jbossEsbXml = JBossDeployerUtil.readEsbConfig(getClass().getResourceAsStream("jbossesb_config_webgateway.xml"));
        ModelAdapter model = JBossDeployerUtil.getJbossEsbModel(jbossEsbXml);
        String deploymentName = "webgateway";
        File esbWarFiles = new File(System.getProperty("java.io.tmpdir"));
        File esbArchive = new File(getClass().getResource("webgateway.esb").getFile());
        ClassLoader localCl = Thread.currentThread().getContextClassLoader();

        WebGatewayBuilder builder = new WebGatewayBuilder(esbWarFiles, esbArchive, deploymentName, localCl, model);

        File war = builder.build();
        assertTrue(war.exists());
        assertEquals("webgateway.war", war.getName());
        war.delete();
    }
}
