/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.config.mappers131;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.ConfigurationException;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class CamelGatewayMapperUnitTest extends TestCase {

	public void test_addRouteXML() throws ConfigurationException {
		
		List<String> routeXMLs = new ArrayList<String>();
		
		CamelGatewayMapper.addRouteXML(URI.create("file://indir?delete=true"), URI.create("jbossesb://blah"), routeXMLs);
		CamelGatewayMapper.addRouteXML(URI.create("esbschedule:5000:file://indir?delete=true"), URI.create("jbossesb://blah"), routeXMLs);
		
		assertEquals("<route><from uri=\"file://indir?delete=true\"/><to uri=\"jbossesb://blah\"/></route>", routeXMLs.get(0));
		assertTrue(routeXMLs.get(1).startsWith("<route><from uri=\"timer://"));
		assertTrue(routeXMLs.get(1).endsWith("?fixedRate=true&delay=0&period=5000\"/><to uri=\"file://indir?delete=true\"/><to uri=\"jbossesb://blah\"/></route>"));
	}
}
