/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.message;

import java.util.ArrayList;
import java.util.List;

class MockActionInfo
{
    private static int actionId ;
    private static List<Integer> initialiseList ;
    private static List<Integer> processList ;
    private static List<Integer> successList ;
    private static List<Integer> exceptionList ;
    private static List<Integer> destroyList ;
    
    static synchronized void reset()
    {
        actionId = 0 ;
        initialiseList = new ArrayList<Integer>() ;
        processList = new ArrayList<Integer>() ;
        successList = new ArrayList<Integer>() ;
        exceptionList = new ArrayList<Integer>() ;
        destroyList = new ArrayList<Integer>() ;
    }
    
    static synchronized Integer getNextId()
    {
        return Integer.valueOf(actionId++) ;
    }
    
    static synchronized void addInitialiseId(final Integer id)
    {
        initialiseList.add(id) ;
    }
    
    static synchronized Integer[] getInitialiseList()
    {
        return (Integer[])initialiseList.toArray(new Integer[initialiseList.size()]) ;
    }
    
    static synchronized void addProcessId(final Integer id)
    {
        processList.add(id) ;
    }
    
    static synchronized Integer[] getProcessList()
    {
        return (Integer[])processList.toArray(new Integer[processList.size()]) ;
    }
    
    static synchronized void addSuccessId(final Integer id)
    {
        successList.add(id) ;
    }
    
    static synchronized Integer[] getSuccessList()
    {
        return (Integer[])successList.toArray(new Integer[successList.size()]) ;
    }
    
    static synchronized void addExceptionId(final Integer id)
    {
        exceptionList.add(id) ;
    }
    
    static synchronized Integer[] getExceptionList()
    {
        return (Integer[])exceptionList.toArray(new Integer[exceptionList.size()]) ;
    }
    
    static synchronized void addDestroyId(final Integer id)
    {
        destroyList.add(id) ;
    }
    
    static synchronized Integer[] getDestroyList()
    {
        return (Integer[])destroyList.toArray(new Integer[destroyList.size()]) ;
    }
}
