/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import javax.sql.DataSource;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.persist.JdbcCleanConn;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.xml.sax.SAXException;

/**
 * NotifySqlTable unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class NotifySqlTableUnitTest extends TestCase {

	public void test_NotifySqlTable() throws Exception {
		ConfigTree domEl = ConfigTree.fromInputStream(getClass().getResourceAsStream("NotifySqlTable_testfile1.xml"));
		NotifySqlTable nst = new NotifySqlTable(domEl);
	}
	
	public void test_sendNotificationNegative() throws SAXException, IOException, ConfigurationException
	{
		ConfigTree domEl = ConfigTree.fromInputStream(getClass().getResourceAsStream("NotifySqlTable_testfile1.xml"));
		NotifySqlTable nst = new MockNotifySqlTable(domEl);
        org.jboss.soa.esb.message.Message message = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
        message.getBody().add((new Integer(123).toString().getBytes()));
        try
        {
			nst.sendNotification( message );
			fail( "sendNotification should have thrown an NotificationException");
        }
        catch( Exception e )
        {
        	assertTrue ( e instanceof NotificationException );
        }
		
	}
	
	private static class MockNotifySqlTable extends NotifySqlTable
	{

		public MockNotifySqlTable(ConfigTree p_oP) throws ConfigurationException
		{
			super( p_oP );
		}

		@Override
		protected JdbcCleanConn createJdbcCleanConnection()
		{
			return new MockJdbcCleanConn( null );
		}
	}
	
	private static class MockJdbcCleanConn extends JdbcCleanConn
	{

		public MockJdbcCleanConn(DataSource p_oDS)
		{
			super( p_oDS );
		}

		@Override
		public PreparedStatement prepareStatement( String p_sSt ) throws SQLException
		{
			throw new SQLException( "MockJdbcCleanConn prepareStatement throwing SQLException");
		}
		
		
	}
}
