/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.schedule.JBESB_2146;

import junit.framework.TestCase;

import org.jboss.soa.esb.mock.MockAction;
import org.jboss.soa.esb.schedule.MockScheduledEventListener;
import org.jboss.soa.esb.schedule.MockScheduledEventMessageComposer;
import org.jboss.soa.esb.testutils.ESBConfigUtil;

/**
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JBESB_2146_UnitTest extends TestCase {

    protected void setUp() throws Exception {
        MockScheduledEventMessageComposer.reset();
        MockScheduledEventListener.reset();
        MockAction.message = null;
    }

    public void test_simple_schedule_01() throws Exception {
        runTestConfig("config-01.xml", 10000);

        JBESB_2146_ScheduledEventMessageComposer composer1 = JBESB_2146_ScheduledEventMessageComposer.getComposer("simple-schedule-listener1");
        JBESB_2146_ScheduledEventMessageComposer composer2 = JBESB_2146_ScheduledEventMessageComposer.getComposer("simple-schedule-listener2");

        assertTrue("simple-schedule-listener1 fired", composer1.composedMessages.size() > 0);
        assertTrue("simple-schedule-listener2 fired", composer2.composedMessages.size() > 0);
    }

    private void runTestConfig(String configName, long upTime) throws Exception {
        ESBConfigUtil configUtil = new ESBConfigUtil(getClass().getResourceAsStream(configName));

        configUtil.startController();
        Thread.sleep(upTime);
        configUtil.stopController();
    }
}