/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.jboss.soa.esb.services.security.auth.ws.WSTestUtil.*;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Iterator;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

import junit.framework.JUnit4TestAdapter;

import org.junit.Test;

/**
 * Unit test for {@link SOAPExtractorUtil}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class SOAPExtractorUtilUnitTest
{
    @Test
    public void getSecurityHeaderNullEnvelope() throws Exception
    {
        SOAPHeaderElement securityHeader = SOAPExtractorUtil.extractSecurityHeader(null);
        assertNull(securityHeader);
    }
    
    @Test
    public void shouldExtract10From2002SecurityHeader() throws Exception
    {
        final SOAPMessage soapMessage = createMessage("soap-security-header-2002-1.0-example.xml", getClass());
        SOAPHeaderElement securityHeader = SOAPExtractorUtil.extractSecurityHeader(soapMessage.getSOAPPart().getEnvelope());
        
        assertSecurityNS(securityHeader, SoapConstants.WSSE_2_QNAME);
    }
    
    @Test
    public void shouldExtract10SecurityHeader() throws Exception
    {
        final SOAPMessage soapMessage = createMessage("soap-security-header-1.0-example.xml", getClass());
        SOAPHeaderElement securityHeader = SOAPExtractorUtil.extractSecurityHeader(soapMessage.getSOAPPart().getEnvelope());
        
        assertSecurityNS(securityHeader, SoapConstants.WSSE_QNAME);
    }
    
    @Test
    public void shouldExtractVersion11SecurityHeader() throws Exception
    {
        final SOAPMessage soapMessage = createMessage("soap-security-header-1.1-example.xml", getClass());
        SOAPHeaderElement securityHeader = SOAPExtractorUtil.extractSecurityHeader(soapMessage.getSOAPPart().getEnvelope());
        
        assertSecurityNS(securityHeader, SoapConstants.WSSE_11_QNAME);
    }
    
    private void assertSecurityNS(final SOAPHeaderElement securityHeader, final QName qname)
    {
        assertEquals(qname.getNamespaceURI(), securityHeader.getNamespaceURI());
        final Iterator<?> assertionElement = securityHeader.getChildElements(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion", "saml"));
        assertTrue(assertionElement.hasNext());
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SOAPExtractorUtilUnitTest.class);
    }

}
