/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.InputStream;
import java.util.Set;

import javax.xml.soap.SOAPMessage;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Test;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;

/**
 * Unit test for {@link SamlSoapAssertionExtractor}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * 
 */
public class SamlSoapAssertionExtractorUnitTest
{
    @Test
    public void extractAssertionFromSOAPMessage() throws Exception
    {
        final SamlSoapAssertionExtractor extractor = new SamlSoapAssertionExtractor();
        final SOAPMessage soap = WSTestUtil.createMessage("soap-saml-example.xml", getClass());

        final AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);

        assertNotNull(authRequest);
        final Set<?> credentials = authRequest.getCredentials();
        assertFalse(credentials.isEmpty());
        assertEquals(1, credentials.size());
        final Object credential = credentials.iterator().next();
        assertTrue(credential instanceof SamlCredential);

        final String expectedAssertion = readFile("saml-expected-example.xml");
        final String actualAssertion = ((SamlCredential) credential).getAssertionAsString();
        assertTrue(XMLHelper.compareXMLContent(expectedAssertion, actualAssertion));
    }

    private String readFile(final String fileName) throws Exception
    {
        InputStream inputStream = ClassUtil.getResourceAsStream(fileName, getClass());
        return new String(StreamUtils.readStream(inputStream));
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SamlSoapAssertionExtractorUnitTest.class);
    }

}
