/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;

import junit.framework.JUnit4TestAdapter;

import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 * Tests the XPathUtil class
 * 
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 * @since 4.2
 *
 */
public class XPathUtilTest
{
	private String xml = "<someNode><childnode><name>Daniel</name></childnode></someNode>";
	
	@Test( expected= IllegalArgumentException.class )
	public void getDocumentNegative() throws SAXException, IOException, ParserConfigurationException
	{
		XPathUtil.getDocument( null );
	}
	
	@Test
	public void getDocument() throws SAXException, IOException, ParserConfigurationException
	{
		Document document = XPathUtil.getDocument( xml );
		assertNotNull( document );
	}
	
	@Test( expected= IllegalArgumentException.class )
	public void getNodeFromXPathExpressionNegative_null_document( ) throws XPathExpressionException
	{
		Document document = null;
		XPathUtil.getNodeFromXPathExpression( document, "/some/path[0]" );
	}
	
	@Test
	public void getNodeFromXPathExpression( ) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException
	{
		Element node = XPathUtil.getNodeFromXPathExpression( XPathUtil.getDocument( xml ), "/someNode/childnode" );
		assertEquals( "childnode", node.getNodeName() );
	}
	
	@Test
	public void getNodeFromXPathExpression_sibling( ) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException
	{
		String xml = "<someNode><childnode><name>Daniel</name></childnode><childnode><name>Bövenius</name></childnode></someNode>";
		Element node = XPathUtil.getNodeFromXPathExpression( XPathUtil.getDocument( xml ), "/someNode/childnode[2]" );
		assertEquals( "childnode", node.getNodeName() );
		Node nameNode = node.getElementsByTagName( "name" ).item( 0 );
		assertNotNull( nameNode );
		assertEquals( "Bövenius", nameNode.getTextContent() );
	}
	
	@Test
	public void getNodeFromXPathExpression_StringXml_and_XPathExpression() throws XPathExpressionException, SAXException, IOException, ParserConfigurationException
	{
		Element node = XPathUtil.getNodeFromXPathExpression( xml, "/someNode/childnode" );
		assertEquals( "childnode", node.getNodeName() );
	}
	
	/*
	 * Just here to help Ant to find annotated test.
	 */
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( XPathUtilTest.class );
	}	

}
