/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.services.jbpm.cmd;

import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jboss.soa.esb.services.jbpm.Mapping;

public class ConfigUtil 
{
	static List<Mapping> getMappingConfig(ConfigTree tree)
		throws ConfigurationException
	{   
        List<Mapping> mappingList = new ArrayList<Mapping>();
        ConfigTree[] mappingElements = tree.getChildren(Constants.MAPPING_TAG);
        if (mappingElements != null) {
            for (ConfigTree mappingElement : mappingElements) {
                Mapping mapping = Mapping.parseMappingElement(mappingElement);
                mappingList.add(mapping);
            }
        }
		return mappingList;
	}

	static String[] actorsFromConfig(ConfigTree tree, boolean acceptValue)
		throws ConfigurationException
	{
		String tag = Constants.ACTORS_TAG;
		ConfigTree[] childs = tree.getChildren(tag);
		if (null==childs || childs.length<1)
			return null;
		if (childs.length>1)
			throw new ConfigurationException("Only one <"+tag
					+"> element allowed in configuration");
		
		tag = Constants.ONE_ACTOR_TAG;
		childs	= childs[0].getChildren(tag);
		if (null==childs || childs.length<1)
			throw new ConfigurationException("At least one <"+tag
					+"> child element required for <"+Constants.VARIABLES_TAG+">");
		String[] ret = new String[childs.length];
		int i1=0;
		for (ConfigTree curr: childs)
		{
			String name		= curr.getAttribute("name");
			if (null==name)
			{
				throw new ConfigurationException
				("You must specify the 'name' attribute for all <"
						+tag+"> element");
			}
			ret[i1++]	= name;
		}
		return ret;
	}

}
