/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm5.actions;

import java.util.HashMap;
import java.util.Map;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

/**
 * Maps BPM parameters from either values in the configuration or ESB
 * message properties.
 *  
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.11
 */
public class BpmParameterMapper {
	private static final String MAPPING_TAG = "mapping";
	
	private static final String ESB_TAG = "esb";
	private static final String BPM_TAG = "bpm";
	private static final String VALUE_TAG = "value";
	
	/**
	 * Map ESB properties to BPM properties.    If a value attribute exists,
	 * use the value attribute as the value of the BPM property.    If no
	 * value attribute exists, map the value of the ESB message property to the
	 * BPM property.
	 * @param msg message
	 * @param tree ConfigTree
	 * @return 
	 */
	public static Map<String,Object> mapPropertiesToParams(Message msg, 
			ConfigTree tree) {
		
		HashMap<String,String> mappingsOfParams = new HashMap<String, String>();
		Map<String, Object> params = new HashMap<String,Object>();
		
		ConfigTree[] mappings = tree.getChildren(MAPPING_TAG);
		for (int i = 0; i < mappings.length; i++) {
			ConfigTree mapTree = mappings[i];
			String value = mapTree.getAttribute(VALUE_TAG);

			// If value isn't set, include the esb->bpm mapping in the mappings we
			// check message properties for.    If value is set, use it instead.
			if (value == null) {
				mappingsOfParams.put(mapTree.getAttribute(ESB_TAG), mapTree.getAttribute(BPM_TAG));
			} else {
				params.put(mapTree.getAttribute(BPM_TAG), value);
			}
		}

		// Now that we have the mapping, add the bpm key and the message property value
		for (String esb : mappingsOfParams.keySet()) {
			params.put(mappingsOfParams.get(esb), msg.getProperties().getProperty(esb));
		}
		
		return params;
	}
}
