/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.services.rules;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.rules.RuleService;
import org.jboss.soa.esb.util.ClassUtil;
/**
 * Returns an instance of the RuleService.
 *
 * @author jdelong@redhat.com
 *
 */
public class RuleServiceFactory {
	private static Logger logger = Logger.getLogger(RuleServiceFactory.class);

	/**
	 * This factory returns a ruleService
	 * 
	 * @author jdelong@redhat.com
	 * 
	 */
	public static RuleService getRuleService(String className)
			throws RuleServiceException {
		RuleService rs = null;
		logger.log(Level.DEBUG, "Going to load " + className);
		try {
			// instruct class loader to load the RuleService Implementation
			Class<?> rsClass = ClassUtil.forName(className,
					RuleServiceFactory.class);
			// Try to get an instance of the RS
			rs = (RuleService) rsClass.newInstance();
		} catch (ClassNotFoundException cnfex) {
			throw new RuleServiceException("RuleService Implementation="
					+ className + " not found", cnfex);
		} catch (Exception e) {
			throw new RuleServiceException(className + " invocation problem. "
					+ e.getLocalizedMessage(), e);
		}
		return rs;
	}
}
