/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.rules;

import java.util.List;
import java.util.Map;

import org.drools.runtime.Channel;
import org.jboss.soa.esb.services.rules.RuleInfo;
import org.jboss.soa.esb.services.rules.RuleService;
import org.jboss.soa.esb.services.rules.StatefulRuleInfo;

/**
 * StatefulRuleInfoImpl contains stateful rule execution configuration parameters that 
 * are passed to the {@link RuleService}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * @since 4.6
 */
public class StatefulRuleInfoImpl implements StatefulRuleInfo
{
    private final RuleInfo ruleInfo;
    private final boolean dispose;
    private final boolean continueState;
    
    public StatefulRuleInfoImpl(final RuleInfo ruleInfo, final boolean dispose, final boolean continueState)
    {
    	this.ruleInfo = ruleInfo;
        this.dispose = dispose;
        this.continueState = continueState;
    }
    
    public boolean dispose()
    {
        return this.dispose;
    }
    
    public boolean continueState()
    {
        return this.continueState;
    }

    public String getDslSource()
    {
        return ruleInfo.getDslSource();
    }

    public Map<String, List<Object>> getFacts()
    {
        return ruleInfo.getFacts();
    }

    public Map<String, Object> getGlobals()
    {
        return ruleInfo.getGlobals();
    }

    public boolean getReload()
    {
        return ruleInfo.getReload();
    }

    public String getRuleSource()
    {
        return ruleInfo.getRuleSource();
    }

    public String getRuleType()
    {
        return ruleInfo.getRuleType();
    }
    
    public List<Object> getDefaultFacts()
    {
        return ruleInfo.getDefaultFacts();
    }
    
    public String getAuditType()
    {
        return ruleInfo.getAuditType();
    }
    
    public String getAuditFile()
    {
        return ruleInfo.getAuditFile();
    }
    
    public Integer getAuditInterval()
    {
        return ruleInfo.getAuditInterval();
    }
    
    public String getClockType()
    {
        return ruleInfo.getClockType();
    }
    
    public String getEventProcessingType()
    {
        return ruleInfo.getEventProcessingType();
    }
    
    public Boolean getMultithreadEvaluation()
    {
    	return ruleInfo.getMultithreadEvaluation();
    }
    
    public Integer getMaxThreads()
    {
    	return ruleInfo.getMaxThreads();
    }
    
    public Map<String,Channel> getChannels()
    {
    	return ruleInfo.getChannels();
    }
    
    public String getRuleFireMethod()
    {
    	return ruleInfo.getRuleFireMethod();
    }
    
    public Boolean getDefaultContinue()
    {
        return ruleInfo.getDefaultContinue();
    }
}
