/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.soa.esb.services.rules;

import org.drools.runtime.Channel;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.format.MessageFactory;

/**
 * ServiceChannel.
 * 
 * @author dward at jboss.org
 */
public class ServiceChannel implements Channel, Configurable
{
	
	public static final String ASYNC = "async";
	public static final String TIMEOUT = "timeout";
	
	private Service service;
	private boolean async;
	private long timeout;
	private MessagePayloadProxy payloadProxy;
	
	public ServiceChannel() {}
	
	public void setConfiguration(ConfigTree config) throws ConfigurationException
	{
		service = Service.getService(
				config.getRequiredAttribute(ListenerTagNames.SERVICE_CATEGORY_NAME_TAG),
				config.getRequiredAttribute(ListenerTagNames.SERVICE_NAME_TAG) );
		async = config.getBooleanAttribute(ASYNC, true);
		timeout = config.getLongAttribute(TIMEOUT, 30000L);
		payloadProxy = new MessagePayloadProxy(config);
	}
	
	public Service getService()
	{
		return service;
	}

	public void send(Object object)
	{
		if (object != null)
		{
			Message msg_in = MessageFactory.getInstance().getMessage();
			try
			{
				payloadProxy.setPayload(msg_in, object);
				ServiceInvoker invoker = new ServiceInvoker(service);
				if (async)
				{
					invoker.deliverAsync(msg_in);
				}
				else
				{
					invoker.deliverSync(msg_in, timeout);
				}
			}
			catch (Throwable t)
			{
				if (t instanceof RuntimeException)
				{
					throw (RuntimeException)t;
				}
				else
				{
					throw new RuntimeException(t);
				}
			}
		}
	}

}
