/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class ConfigBuilder
{
    private ConfigTree config;
    
    // key=type
    // value=location
    private Map<String, String> args;
        
    public ConfigBuilder()
    {
        config = new ConfigTree("ejbprocessor");
    }
    
    public ConfigBuilder methodName(final String methodName)
    {
        if (methodName != null)
	        config.setAttribute(EJBProcessor.EJB_METHOD, methodName);
        return this;
    }
    
    public ConfigBuilder outputLocation(final String outputLocation)
    {
        if (outputLocation != null)
	        config.setAttribute(EJBProcessor.OUT_VAR, outputLocation);
        return this;
    }
    
    public ConfigBuilder jndiName(final String jndiName)
    {
        if (jndiName != null)
	        config.setAttribute(EJBProcessor.JNDI_NAME, jndiName);
        return this;
    }
    
    public ConfigBuilder initCtxFactory(final String factory)
    {
        if (factory != null)
	        config.setAttribute(EJBProcessor.INICTXFACTORY, factory);
        return this;
    }
    
    public ConfigBuilder providerUrl(final String url)
    {
        if (url != null)
	        config.setAttribute(EJBProcessor.PROVIDERURL, url);
        return this;
    }
    
    public ConfigBuilder isEjb3(final Boolean on)
    {
        if (on != null)
	        config.setAttribute(EJBProcessor.EJB3_ATTRIBUTE, on.toString());
        return this;
    }
    
    public ConfigBuilder arg(final Class<?> type, final String location)
    {
        if (args == null)
            args = new LinkedHashMap<String, String>();
        
        args.put(type.getName(), location);
        return this;
    }
    
    public ConfigBuilder username(final String username)
    {
        if (username != null)
	        config.setAttribute(EJBProcessor.SECURITY_PRINCIPAL, username);
        return this;
    }
    
    public ConfigBuilder password(final String password)
    {
        if (password != null)
	        config.setAttribute(EJBProcessor.SECURITY_CREDENTIALS, password);
        return this;
    }
    
    public ConfigBuilder securityLoginModule(String moduleName)
    {
        if (moduleName != null)
	        config.setAttribute(EJBProcessor.SECURITY_LOGIN_MODULE, moduleName);
        return this;
    }
    
    public ConfigTree build()
    {
        if (args != null)
        {
            int i = 0;
            Set<Entry<String, String>> entrySet = args.entrySet();
            for (Entry<String, String> entry : entrySet)
            {
				ConfigTree arg = new ConfigTree("arg" + i, config);
				arg.setAttribute("type", entry.getKey());
				arg.addTextChild(entry.getValue());
				i++;
            }
        }
        return config;
    }

    public ConfigBuilder lazyEJBInit(final Boolean on)
    {
        if (on != null)
            config.setAttribute(EJBProcessor.LAZY_EJB_INIT, on.toString());
        return this;
    }

}

