/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.security.auth.callback.CallbackHandler;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class MockEjbProcessor extends EJBProcessor
{
    private Properties jndiProperties;
    
    private String loginModuleName;

    private CallbackHandler callbackHandler;
    
	public MockEjbProcessor(ConfigTree config)
	{
		super(config);
	}
	
	@Override
	Object getEjb3FromJndi(final Context context) throws ActionLifecycleException
    {
		return new SimpleSLSB();
    }

	@Override
	InitialContext getInitialContext(Properties props) throws ActionLifecycleException
	{
	    this.jndiProperties = props;
		return null;
	}
	
	@Override
    void login(String loginModuleName, final CallbackHandler callbackHandler) throws ActionLifecycleException
    {
        this.loginModuleName = loginModuleName;
        this.callbackHandler = callbackHandler;
    }

    public Properties getJndiProperties()
	{
	    return jndiProperties;
	}

    public CallbackHandler getCallbackHandler()
    {
        return callbackHandler;
    }

    public String getLoginModuleName()
    {
        return loginModuleName;
    }

    public Object getEJB3Interface()
    {
        return ejb3Interface;
    }
}
