/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.soap.cxf;

import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.cxf.Bus;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.CXFServletExt;
import org.jboss.wsf.stack.cxf.ServletControllerExt;

public class ESBCXFServletExt extends CXFServletExt
{
    public void init(final ServletConfig servletConfig)
        throws ServletException
    {
        super.init(servletConfig) ;
        final Endpoint endpoint = getEndpoint(servletConfig.getServletContext()) ;
        final Map<Class<?>, Object> extensions = endpoint.getAttachment(Map.class) ;
        if (extensions != null)
        {
            extensions.put(ServletControllerExt.class, controller) ;
            extensions.put(Bus.class, bus) ;
        }
    }
    
    private Endpoint getEndpoint(final ServletContext context)
        throws ServletException
    {
        String contextPath = context.getContextPath() ;
        if (contextPath.startsWith("/"))
        {
            contextPath = contextPath.substring(1) ;
        }

        Endpoint endpoint = null ;
        String servletName = getServletName() ;
        for (ObjectName sepId : epRegistry.getEndpoints())
        {
            String propContext = sepId.getKeyProperty(Endpoint.SEPID_PROPERTY_CONTEXT) ;
            String propEndpoint = sepId.getKeyProperty(Endpoint.SEPID_PROPERTY_ENDPOINT) ;
            if (servletName.equals(propEndpoint) && contextPath.equals(propContext))
            {
                endpoint = epRegistry.getEndpoint(sepId) ;
                break ;
            }
        }

        if (endpoint == null)
        {
            throw new ServletException("Could not obtain endpoint for context: " + contextPath + ", servlet name: " + servletName) ;
        }
        else
        {
            return endpoint ;
        }
    }
}
