/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.soa.esb.actions.soap.adapter.cxf;

import java.util.Collection;
import java.util.Set;

import org.apache.cxf.Bus;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;

/**
 * A specialisation of the servlet transport factory acting as a procy for the real transport.
 *  
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class SOAPProcessorServletTransportFactory extends ServletTransportFactory
{

    private final ServletTransportFactory proxy ;
    
    public SOAPProcessorServletTransportFactory(final Bus bus, final ServletTransportFactory proxy)
    {
        super(bus) ;
        this.proxy = proxy ;
    }
    
    @Override
    public Collection<ServletDestination> getDestinations()
    {
        return proxy.getDestinations() ;
    }
    
    @Override
    public Set<String> getDestinationsPaths()
    {
        return proxy.getDestinationsPaths() ;
    }
    
    @Override
    public ServletDestination getDestinationForPath(final String path)
    {
        return proxy.getDestinationForPath(path) ;
    }
    
    @Override
    public ServletDestination getDestinationForPath(final String path, final boolean tryDecoding)
    {
        return proxy.getDestinationForPath(path, tryDecoding);
    }
}
