/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap;

import junit.framework.TestCase;

import java.util.Properties;
import java.io.File;
import java.io.StringReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.jboss.soa.esb.listeners.config.Action;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.internal.soa.esb.publish.ContractInfo;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class AbstractWsdlContractPublisherUnitTest extends TestCase {

    public void test_transform_01() throws Exception {
        Action actionConfig = new Action(null, null, null, new Properties());

        actionConfig.getProperties().setProperty("rewrite-endpoint-url", "true");
        actionConfig.getProperties().setProperty("wsdlTransform", "/org/jboss/soa/esb/actions/soap/wsdl-transform.xml");
        execTransformTest(actionConfig, "wsdl-transform.expected-01.xml"); // Both transforms
    }

    public void test_transform_02() throws Exception {
        Action actionConfig = new Action(null, null, null, new Properties());

        actionConfig.getProperties().setProperty("rewrite-endpoint-url", "false");
        actionConfig.getProperties().setProperty("wsdlTransform", "/org/jboss/soa/esb/actions/soap/wsdl-transform.xml");
        execTransformTest(actionConfig, "wsdl-transform.expected-02.xml"); // Just the user defined transform
    }

    public void test_transform_03() throws Exception {
        Action actionConfig = new Action(null, null, null, new Properties());

        actionConfig.getProperties().setProperty("rewrite-endpoint-url", "false");
        execTransformTest(actionConfig, "/test-in.wsdl"); // Neither transforms - should be unchanged from the in-wsdl
    }

    public void test_transform_04() throws Exception {
        Action actionConfig = new Action(null, null, null, new Properties());

        actionConfig.getProperties().setProperty("rewrite-endpoint-url", "true");
        execTransformTest(actionConfig, "wsdl-transform.expected-04.xml"); // Just the url rewriting transform
    }

    private void execTransformTest(Action actionConfig, String expected) throws ConfigurationException, SAXException, IOException, ParserConfigurationException {
        TestWsdlContractPublisher publisher = new TestWsdlContractPublisher();
        publisher.setActionConfig(actionConfig);
        ContractInfo contractInfo = publisher.getContractInfo(new EPR(URI.create("http://x.y.x:8989/")));

        assertTrue("XML Comparison", XMLHelper.compareXMLContent(new InputStreamReader(getClass().getResourceAsStream(expected)), new StringReader(contractInfo.getData())));
    }

    private class TestWsdlContractPublisher extends AbstractWsdlContractPublisher {

        public String getWsdlAddress() {
            URL resource = getClass().getResource("/test-in.wsdl");
            File testFile = new File(resource.getFile());

            try {
                return testFile.toURL().toString();
            } catch (MalformedURLException e) {
                fail("Failed to create URL object from file path: " + e.getMessage());
                return null;
            }
        }

        public Properties getHttpClientProperties() {
            return getActionProperties();
        }
    }
}
