/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.spring;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.junit.Test;

/**
 * Unit tests for org.jboss.soa.esb.actions.AbstractSpringAction
 * <p/> 
 * @author <a href="mailto:james.williams@redhat.com">james.williams@redhat.com</a>
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 */
public class AbstractSpringActionUnitTest 
{
	private final String springContext1 = "/spring-context-1.xml";
	private final String springContext2 = "/spring-context-2.xml";
	
	@Test ( expected = ActionLifecycleException.class )
    public void nullConfigTree() throws Exception
    {
		new MockSpringAction( createConfig() );
	}

	@Test
    public void test_bean_factory_load_single() throws Exception
    {
        MockSpringAction mockAction = createMockAction( new String[] { springContext1 } );
        assertEquals("hello from Spring", mockAction.sayHelloSpring());
        assertEquals(false, mockAction.isBeanFactoryNull());
    }

    @Test
    public void test_bean_factory_load_multiple() throws Exception
    {
        MockSpringAction mockAction = createMockAction( new String[] { springContext1, springContext2 } );
        assertEquals("hello from Spring", mockAction.sayHelloSpring());
        assertEquals("goodbye from Spring", mockAction.sayGoodbyeSpring());
        assertEquals(false, mockAction.isBeanFactoryNull());
    }

    @Test
    public void test_spring_aop() throws Exception
    {
        MockSpringAction mockAction = createMockAction( new String[] { springContext1 } );
        assertEquals("Greeting Changed", mockAction.sayHelloAopStyle());
        assertEquals(false, mockAction.isBeanFactoryNull());
    }
    
    @Test
    public void destroy() throws Exception
    {
        MockSpringAction mockAction = createMockAction( new String[] { springContext1, springContext2 } );
        mockAction.sayHelloSpring();
        assertFalse(mockAction.isBeanFactoryNull());
        mockAction.destroy();
        assertTrue(mockAction.isBeanFactoryNull());
    }
    
	@Test (expected = ActionLifecycleException.class)
    public void exptySpringContextFile() throws Exception
    {
        createMockAction( new String[] { "" } );
    }
       
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter( AbstractSpringActionUnitTest.class );
    }
    
	private ConfigTree createConfig()
	{
        return new ConfigTree("<config/>");
	}
	
	private MockSpringAction createMockAction( String[] files) throws Exception
	{
        final ConfigTree config = createConfig();
        if (files.length == 1)
        {
            config.setAttribute( "springContextXml" , files[0]);
        }
        else
        {
            final StringBuilder sb = new StringBuilder();
            for (String configFile : files)
    		{
            	sb.append(configFile).append(",");
    		}
            config.setAttribute( "springContextXml" , sb.toString() );
        }
        return new MockSpringAction( config );
	}
}
