package org.jbosson.plugins.jbossesb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas.util.FileContentDelegate;

/**
 * Component for ESB package deployment.
 *
 * @author Tom Cunningham
 * @param <T>
 */
public class ESBDeploymentComponent extends AbstractDeploymentComponent {
	public void deleteResource() throws Exception {
        Configuration pluginConfiguration = getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimple("deployment").getStringValue();
        
        ESBComponent jbossASComponent = (ESBComponent) getResourceContext().getParentResourceComponent();
        //File deploymentFile = jbossASComponent.getDeploymentFilePath(super.resourceContext.getResourceKey());

        final File deploy = new File(jbossASComponent.getConfigurationPath(), "deploy");
        final File file = new File(deploy, fullFileName);

        if (!file.exists()) {
            throw new Exception("Cannot find application file to delete: " + fullFileName);
        }

        if (file.isDirectory()) {
            deleteDirectoryContents(file.listFiles());
        }

        boolean result = file.delete();

        if (!result) {
            throw new Exception("File delete call returned unsuccessful with no further detail");
        }
	}
}
