package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;	

import org.jboss.soa.esb.samples.quickstart.business_ruleservice_cep.status.*;
import org.jboss.soa.esb.samples.quickstart.business_ruleservice_cep.spoke.*;
import org.jboss.soa.esb.samples.quickstart.business_ruleservice_cep.hub.*;

public class BusinessRulesServiceCEPTest extends AbstractQuickstartTestCase {
	public BusinessRulesServiceCEPTest(String name) {
		super(name);
	}

    private static final Map<String,Spoke> spokes = new HashMap<String,Spoke>();
    static {
            for (String location : new String[]{"Atlanta", "Boulder", "Chicago"}) {
                    Spoke spoke = new Spoke(location);
                    spokes.put(location, spoke);
                    for (String partName : new String[]{"widget", "sprocket", "nut", "bolt"}) {
                            spoke.addPart(partName);
                    }
            }
    }
	
    private static final Random RANDOM = new Random();

    private static synchronized int random(int max)
    {
            return RANDOM.nextInt(max);
    }
    
    private static boolean adjustPart(String[] args, boolean increment) throws Exception
    {
    		System.out.println("adjustPart " + args[0] + " " 
    				+ args[1]);
            boolean understood = false;
            for (int a=1; a < args.length; a++)
            {
                    String[] sp = args[a].split(":");
                    for (Spoke spoke : spokes.values())
                    {
                            if (spoke.getLocation().equalsIgnoreCase(sp[0]))
                            {
                                    for (Part part : spoke.getParts())
                                    {
                                            if (part.getName().equalsIgnoreCase(sp[1]))
                                            {
                                                    understood = true;
                                                    if (increment) {
                                                            part.increment();
                                                    } else {
                                                            part.decrement();
                                                    }
                                            }
                                    }
                            }
                    }
            }
            return understood;
    }
    
	public void cepTest(String... args) throws Exception {
		boolean understood = false;
		if (args.length > 0)
		{
			StatusSender sender = StatusSender.getInstance();
			sender.startConnection();
			if ("startSession".equals(args[0]))
			{
				understood = true;
				sender.startSession();
			}
			else if ("sendHeartbeat".equals(args[0]))
			{
				for (int a=1; a < args.length; a++)
				{
					for (Spoke spoke : spokes.values())
					{
						if (spoke.getLocation().equalsIgnoreCase(args[a]))
						{
							understood = true;
							spoke.heartbeat();
						}
					}
				}
			}
			else if ("populateInventory".equals(args[0]))
			{
				understood = true;
				for (Spoke spoke : spokes.values())
				{
					for (Part part : spoke.getParts())
					{
						part.adjust(random(10));
					}
				}
			}
			else if ("incrementPart".equals(args[0]))
			{
				understood = adjustPart(args, true);
			}
			else if ("decrementPart".equals(args[0]))
			{
				understood = adjustPart(args, false);
			}
			else if ("stopSession".equals(args[0]))
			{
				understood = true;
				sender.stopSession();
			}
			sender.stopConnection();
		}
		if (!understood)
		{
			throw new Exception("could not understand command [" + args + "]");
		}		
	}
	
	public void testStartSession() throws Exception {
		cepTest("startSession", "");
	}
	
	public void testPopulateInventory() throws Exception {
		cepTest("populateInventory", "");
	}
	
	public void testSendHeartbeat() throws Exception {
		cepTest("sendHeartbeat", "Atlanta", "Boulder", "Chicago");
	}
	
	public void testIncrementPart() throws Exception {
		cepTest("incrementPart", "Atlanta:widget", "Boulder:sprocket", "Chicago:nut", "Atlanta:bolt");
	}
	
	public void testDecrementPart() throws Exception {
		cepTest("decrementPart", "Boulder:widget", "Chicago:sprocket", "Atlanta:nut", "Boulder:bolt");
	}
	
	public void testStopSession() throws Exception {
		cepTest("stopSession", "");
	}
	
	public static Test suite() throws Exception {
		return getDeploySetup(BusinessRulesServiceCEPTest.class, "QuickstartMessageStoreServer.sar, Quickstart_business_ruleservice_cep.esb");
	}
	
}
